package fr.estecka.variantscit.mixin;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import fr.estecka.variantscit.IItemModelProvider;
import fr.estecka.variantscit.VariantsCitMod;
import net.minecraft.class_10442;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_9331;

@Mixin(class_10442.class)
public class ItemModelManagerMixin
{
	@WrapOperation(
		method="update",
		at=@At(value="INVOKE", target="net/minecraft/item/ItemStack.get(Lnet/minecraft/component/ComponentType;)Ljava/lang/Object;")
	)
	private @Nullable Object GetVariantModel(class_1799 stack, class_9331<class_2960> type, Operation<class_2960> original)
	{
		final IItemModelProvider module = VariantsCitMod.GetItemModule(stack.method_7909());
		class_2960 modelId;

		if (module == null || (modelId=module.GetModelForItem(stack)) == null)
			return original.call(stack, type);
		else
			return modelId;
	}
}
