package fr.estecka.variantscit;

import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import fr.estecka.variantscit.reload.EModuleContext;
import fr.estecka.variantscit.reload.ModuleLoader;
import fr.estecka.variantscit.reload.MetaModule;
import fr.estecka.variantscit.commands.ModuleCommands;
import fr.estecka.variantscit.modules.IBakedModule;


public class VariantsCitMod
implements ClientModInitializer
{
	static public final String MODID = "variants-cit";
	public static final LabelledLogger LOGGER = new LabelledLogger();

	static public int reloadcount = 0;
	static public final EquippableCache EQUIPABLES = new EquippableCache();
	static private Map<class_1792, IBakedModule> ITEM_MODULES  = Map.of();
	static private Map<class_1792, IBakedModule> EQUIP_MODULES = Map.of();
	static private Map<class_2960, MetaModule> META = Map.of();

	static public @Nullable IBakedModule GetItemModule(class_1792 itemType){
		return ITEM_MODULES.get(itemType);
	}
	static public @Nullable IBakedModule GetEquipmentModule(class_1792 itemType){
		return EQUIP_MODULES.get(itemType);
	}
	static public Map<class_2960,MetaModule> GetMeta(){
		return Map.copyOf(META);
	}
	static public IBakedModule GetModule(EModuleContext context, class_2960 id){
		MetaModule meta = META.get(id);
		if (meta == null)
			return null;
		else {
			return switch (context) {
				default -> throw new IllegalArgumentException();
				case ITEM_MODEL -> meta.itemModule().orElse(null);
				case EQUIPPABLE -> meta.equipModule().orElse(null);
			};
		}
	}

	@Override
	public void onInitializeClient(){
		ModuleCommands.Register();
	}

	static public void OnResourceReload(ModuleLoader.Result result){
		++reloadcount;
		EQUIPABLES.Clear();
		ITEM_MODULES  = result.itemModules;
		EQUIP_MODULES = result.equipModules;
		META = result.allModules;
	}

}
