package fr.estecka.variantscit.commands;

import org.jetbrains.annotations.Nullable;
import com.mojang.brigadier.context.CommandContext;
import fr.estecka.variantscit.reload.EAssetType;
import fr.estecka.variantscit.reload.EModuleContext;
import fr.estecka.variantscit.reload.MetaModule;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public record CommandLogger(
	CommandContext<FabricClientCommandSource> commandContext,
	EModuleContext moduleContext,
	MetaModule metamodule
)
{

/******************************************************************************/
/* # Generic logging                                                          */
/******************************************************************************/

	static public class_5250 TextOf(Object obj){
		if (obj instanceof class_2561 text)
			return text.method_27661();
		else
			return class_2561.method_43470(String.valueOf(obj));
	}

	static public class_5250 TextFormat(class_124 style, String format, Object... args){
		class_5250 result = class_2561.method_43473().method_27692(style);

		String remainder = format;
		int i = 0;
		int argPos;
		while (i < args.length && 0 <= (argPos=remainder.indexOf("{}"))){
			result.method_27693(remainder.substring(0, argPos));
			result.method_10852(TextOf(args[i]));

			++i;
			remainder = remainder.substring(argPos + 2);
		}

		if (!remainder.isEmpty())
			result.method_27693(remainder);

		return result;
	}

	public class_5250 TextFormat(String format, Object... args){
		return TextFormat(class_124.field_1070, format, args);
	}

	public void Info(class_124 formatting, String format, Object... args){
		this.Info(TextFormat(formatting, format, args));
	}

	public void Info(String format, Object... args){
		this.Info(TextFormat(class_124.field_1070, format, args));
	}

	public void Info(String message){
		this.Info(class_2561.method_43470(message));
	}

	public void Info(class_2561 message){
		commandContext.getSource().sendFeedback(message);
	}

	public void Error(String message){
		this.Error(class_2561.method_43470(message));
	}

	public void Error(class_2561 message){
		commandContext.getSource().sendError(message);
	}

/******************************************************************************/
/* # Preformatted                                                             */
/******************************************************************************/

	static public class_5250 ItemData(@Nullable Object variant){
		return ItemData(variant, "null");
	}

	static public class_5250 ItemData(@Nullable Object variant, String fallback){
		if (variant == null)
			return class_2561.method_43470(fallback).method_27692(class_124.field_1061);
		else
			return TextOf(variant).method_27692(class_124.field_1075);
	}

	static public class_5250 PackData(Object variant){
		return TextOf(variant).method_27692(class_124.field_1054);
	}

	private class_5250 AssetFilename(class_2960 variantId, EAssetType assetType){
		return TextFormat(class_124.field_1054, "/assets/{}/{}/{}{}{}",
			ItemData(variantId.method_12836()),
			assetType.directory,
			metamodule.modelPrefix(),
			ItemData(variantId.method_12832()),
			assetType.suffix
		);
	}

	public void PrintVariantIdTip(class_2960 variantId){
		Info(class_124.field_1080, "[TIP] The model prefix is \"{}\", the variant ID {} may be supported by providing one of these files:",
			PackData(metamodule.modelPrefix()),
			ItemData(variantId)
		);

		class_2561 bullet = class_2561.method_43470("-").method_27692(class_124.field_1080);
		switch (moduleContext())
		{
			default:
				Error("Error: unknown context");
				break;
			case EQUIPPABLE:
				Info(bullet.method_27661().method_10852(AssetFilename(variantId, EAssetType.EQUIPMENT)));
				break;
			case ITEM_MODEL:
				Info(bullet.method_27661().method_10852(AssetFilename(variantId, EAssetType.ITEM_STATE)));
				Info(bullet.method_27661().method_10852(AssetFilename(variantId, EAssetType.BAKED_MODEL)));
				Info(bullet.method_27661().method_10852(AssetFilename(variantId, EAssetType.TEXTURE)));
				break;
		}
	}
}
