package fr.estecka.variantscit.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.modules.IBakedModule;
import fr.estecka.variantscit.reload.EModuleContext;
import fr.estecka.variantscit.reload.MetaModule;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.literal;
import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.argument;
import static com.mojang.brigadier.arguments.BoolArgumentType.bool;
import static com.mojang.brigadier.arguments.BoolArgumentType.getBool;
import static com.mojang.brigadier.arguments.IntegerArgumentType.getInteger;
import static com.mojang.brigadier.arguments.IntegerArgumentType.integer;
import static com.mojang.brigadier.arguments.StringArgumentType.getString;
import static com.mojang.brigadier.arguments.StringArgumentType.greedyString;
import static net.minecraft.class_2232.method_9441;
import static fr.estecka.variantscit.commands.ModuleContextArgumentType.moduleContext;
import static fr.estecka.variantscit.commands.ModuleContextArgumentType.getModuleContext;

public class ModuleCommands
{
	static public final class_2960 ID = class_2960.method_60655(VariantsCitMod.MODID, "modules");

	static public final String CONTEXT_ARG = "context";
	static public final String MODULE_ARG  = "module id";
	
	static public void	Register(){
		ClientCommandRegistrationCallback.EVENT.register(ID, ModuleCommands::RegisterWith);
	}

	static public void	RegisterWith(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess){
		var module = argument(MODULE_ARG, method_9441())
			.suggests(ModuleCommands::ModuleAutofill)
			.then(literal("dump").executes(c->Execute(c, ModuleCommands::Dump)))
			.then(literal("summary").executes(c->Execute(c, ModuleCommands::Summary)))
			.then(literal("walkthrough").executes(c->Execute(c, ModuleCommands::Walkthrough)))
			;

		var context = argument(CONTEXT_ARG, moduleContext())
			.suggests(ModuleCommands::ContextAutofill)
			.then(module)
			;

		var root = literal(VariantsCitMod.MODID)
			.then(context)
			;

		dispatcher.register(root);
	}


/******************************************************************************/
/* # Autofill                                                                 */
/******************************************************************************/

	static private CompletableFuture<Suggestions> ContextAutofill(final CommandContext<FabricClientCommandSource> context, final SuggestionsBuilder builder){
		for (EModuleContext moduleContext : EModuleContext.values())
			builder.suggest(moduleContext.name);
		return builder.buildFuture();
	}

	static private CompletableFuture<Suggestions> ModuleAutofill(final CommandContext<FabricClientCommandSource> context, final SuggestionsBuilder builder){
		EModuleContext moduleContext = getModuleContext(context, CONTEXT_ARG);
		Stream<class_2960> modules = VariantsCitMod.GetMeta().entrySet().stream()
			.filter(entry -> {
				MetaModule meta = entry.getValue();
				return switch (moduleContext){
					default -> false;
					case ITEM_MODEL -> meta.itemModule().isPresent();
					case EQUIPPABLE -> meta.equipModule().isPresent();
				};
			})
			.map(Map.Entry::getKey)
			;

		class_2172.method_9257(modules, builder);

		return builder.buildFuture();
	}


/******************************************************************************/
/* # Command Handlers                                                         */
/******************************************************************************/

	@FunctionalInterface
	static private interface IModuleCommand
	{
		int Execute(CommandContext<FabricClientCommandSource> context, CommandLogger logger, IBakedModule module) throws CommandSyntaxException;
	}

	static private int Execute(CommandContext<FabricClientCommandSource> context, IModuleCommand command) throws CommandSyntaxException {
		EModuleContext moduleContext = getModuleContext(context, CONTEXT_ARG);
		class_2960 moduleId = context.getArgument(MODULE_ARG, class_2960.class);
		MetaModule meta = VariantsCitMod.GetMeta().get(moduleId);
		IBakedModule module = VariantsCitMod.GetModule(moduleContext, moduleId);

		if (module == null){
			context.getSource().sendError(class_2561.method_43470("No such module: "+moduleContext+" "+moduleId));
			return -1;
		}

		CommandLogger logger = new CommandLogger(context, moduleContext, meta);
		return command.Execute(context, logger, module);
	}

	static private int Dump(CommandContext<FabricClientCommandSource> context, CommandLogger logger, IBakedModule module){
		module.Dump(logger);
		return 0;
	}

	static private int Summary(CommandContext<FabricClientCommandSource> context, CommandLogger logger, IBakedModule module){
		module.Summary(logger);
		return 0;
	}

	static private int Walkthrough(CommandContext<FabricClientCommandSource> cmdCtx, CommandLogger logger, IBakedModule module){
		class_1799 stack = cmdCtx.getSource().getPlayer().method_6047();

		logger.Info("--------");
		logger.Info("Testing {} module {} on main-hand item: {} ({})",
			CommandLogger.PackData(logger.moduleContext()),
			CommandLogger.PackData(logger.metamodule().id()).method_27692(class_124.field_1073),
			CommandLogger.ItemData(stack.method_7964()).method_27692(class_124.field_1073),
			CommandLogger.ItemData(stack.method_7909())
		);
		logger.Info("----");

		if (!logger.metamodule().targets().contains(stack.method_7909()))
			logger.Info(class_124.field_1065, "[WARN] This module would normally not be applied to items of type {}", stack.method_7909());

		class_2960 modelId = module.Walkthrough(logger, stack);
		if (modelId != null){
			logger.Info("The module returned the model: {}", CommandLogger.PackData(modelId));
		}
		else
			logger.Info("The module failed to apply to the item.");

		return 0;
	}

}
