package fr.estecka.variantscit.modules.impl;

import org.jetbrains.annotations.Nullable;
import fr.estecka.variantscit.api.ICitModule;
import fr.estecka.variantscit.api.IVariantManager;
import fr.estecka.variantscit.commands.CommandLogger;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public record FallbackModule(ICitModule... innerQueue)
implements ICitModule
{
	@Override
	public @Nullable class_2960 GetItemModel(class_1799 stack, IVariantManager modelProvider) {
		for (ICitModule m : innerQueue){
			class_2960 result = m.GetItemModel(stack, modelProvider);
			if (result != null) return result;
		}

		return null;
	}

	@Override
	public @Nullable class_2960 Walkthrough(class_1799 stack, IVariantManager library, CommandLogger logger) {
		for (ICitModule m : innerQueue){
			class_2960 result = m.Walkthrough(stack, library, logger);
			if (result != null) return result;
		}

		return null;
	}
}
