package fr.estecka.variantscit.modules.impl;

import java.util.Optional;
import net.minecraft.class_1535;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import fr.estecka.variantscit.api.IVariantManager;
import fr.estecka.variantscit.format.properties.PaintingVariantProperty;

/**
 * @implNote
 * Because of the "invalid" special model, this particular module's cache should
 * not be allowed to survive  **datapack**  reloads. However this is unlikely to
 * cause  any issue: so long as  an item stack's lifetime  is tied to its world,
 * then the cached keys  will not survive that world, and thus won't survive the
 * actual reloading of painting variants.
 */
public class PaintingVariantModule
extends AComponentCachingModule<class_6880<class_1535>>
{
	public PaintingVariantModule(){
		super(class_9334.field_56138);
	}

	static public Optional<class_2378<class_1535>> GetPaintingRegistry(){
		@SuppressWarnings("resource")
		class_1937 world = class_310.method_1551().field_1687;
		if (world != null)
			return world.method_30349().method_46759(class_7924.field_41209);
		else
			return Optional.empty();
	}

	public class_2960 GetModelForComponent(class_6880<class_1535> component, IVariantManager models){
		if (component == null)
			return null;
		
		class_2960 variantId = PaintingVariantProperty.UNIT.GetPropertyId(component);

		var registry = GetPaintingRegistry();
		if (registry.isPresent() && !registry.get().method_10250(variantId))
			return models.GetSpecialModel("invalid");

		return models.GetVariantModel(variantId);
	}

}
