package fr.estecka.variantscit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingConstants;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public record ModuleDefinition(
	class_2960 type,
	Optional<List<class_2960>> targets,
	int priority,
	String modelPrefix,
	Optional<class_2960> modelParent,
	Optional<class_2960> fallbackModel,
	Map<String,class_2960> specialModels
)
{
	static public final MapCodec<ModuleDefinition> CODEC = RecordCodecBuilder.<ModuleDefinition>mapCodec(builder->builder
		.group(
			class_2960.field_25139.fieldOf("type").forGetter(ModuleDefinition::type),
			CodecUtil.OneOrMany(class_2960.field_25139).optionalFieldOf("items").forGetter(ModuleDefinition::targets),
			Codec.INT.fieldOf("priority").orElse(0).forGetter(ModuleDefinition::priority),
			Codec.STRING.validate(ModuleDefinition::ValidatePath).fieldOf("modelPrefix").forGetter(ModuleDefinition::modelPrefix),
			class_2960.field_25139.optionalFieldOf("modelParent").forGetter(ModuleDefinition::fallbackModel),
			class_2960.field_25139.optionalFieldOf("fallback").forGetter(ModuleDefinition::fallbackModel),
			Codec.unboundedMap(Codec.STRING, class_2960.field_25139).optionalFieldOf("special", ImmutableMap.<String,class_2960>of()).forGetter(ModuleDefinition::specialModels)
		)
		.apply(builder, ModuleDefinition::new)
	);

	static public DataResult<String> ValidatePath(String path){
		if (class_2960.method_20208(path))
			return DataResult.success(path);
		else
			return DataResult.error(()->"Invalid character in path: "+path);
	}

	public @Nullable class_1091 GetFallbackModelId(){
		return fallbackModel.map(ModelLoadingConstants::toResourceModelId).orElse(null);
	}

	public Map<String, @Nullable class_1091> GetSpecialModelIds(){
		Map<String, @Nullable class_1091> result = new HashMap<>();
		for (var entry : this.specialModels.entrySet())
			result.put(entry.getKey(), ModelLoadingConstants.toResourceModelId(entry.getValue()));
		return result;
	}
}
