package fr.estecka.variantscit;

import fr.estecka.variantscit.format.INbtInput;
import fr.estecka.variantscit.format.IStringTransform;
import fr.estecka.variantscit.format.properties.*;
import fr.estecka.variantscit.format.transforms.*;
import net.minecraft.class_2960;

public final class VCitRegistries
{
	static public final DecodableRegistry<IStringProperty> ITEM_PROPERTIES = new DecodableRegistry<>("property", class_2960.method_60656("item_component"), TransformableProperty::CodecOf);
	static public final DecodableRegistry<IStringTransform> TRANSFORMS = new DecodableRegistry<>("function", class_2960.method_60656("regex"), OptionalTransform::CodecOf);
	static public final DecodableRegistry<INbtInput> NBT_INPUTS = new DecodableRegistry<>("type");

	static {
		ITEM_PROPERTIES.RegisterUnit(class_2960.method_60656("axolotl_variant"), AxolotlVariantProperty.UNIT);
		ITEM_PROPERTIES.Register(class_2960.method_60656("bucket_entity_age"), EntityAgeMapProperty.MAP_CODEC, EntityAgeMapProperty.UNIT);
		ITEM_PROPERTIES.RegisterMap(class_2960.method_60656("item_component"), ItemComponentProperty.MAP_CODEC);
		ITEM_PROPERTIES.RegisterUnit(class_2960.method_60656("item_count"), new ItemCountProperty());
		ITEM_PROPERTIES.RegisterUnit(class_2960.method_60656("item_type"), new ItemTypeProperty());
		ITEM_PROPERTIES.RegisterUnit(class_2960.method_60656("painting_variant"), PaintingVariantProperty.UNIT);

		TRANSFORMS.RegisterUnit(class_2960.method_60656("noop"),               IStringTransform.NOOP);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("null"),               IStringTransform.NULL);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("lowercase"),          String::toLowerCase);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("discard_path"),       IStringTransform::DiscardPath);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("discard_namespace"),  IStringTransform::DiscardNamespace);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("sanitize"),           IStringTransform.SANITIZE);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("sanitize_path"),      IStringTransform.SANITIZE_PATH);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("sanitize_namespace"), IStringTransform.SANITIZE_NAMESPACE);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("sanitize_auto"),      IStringTransform::AutoSanitize);
		TRANSFORMS.RegisterMap(class_2960.method_60656("test"),                TestTransform.MAPCODEC);
		TRANSFORMS.RegisterMap(class_2960.method_60656("successive"),          SuccessiveTransform.MAPCODEC);
		TRANSFORMS.RegisterMap(class_2960.method_60656("alternative"),         AlternativeTransform.MAPCODEC);
		TRANSFORMS.RegisterMap(class_2960.method_60656("whitelist"),           FilterlistTransform.MAPCODEC_WHITELIST);
		TRANSFORMS.RegisterMap(class_2960.method_60656("blacklist"),           FilterlistTransform.MAPCODEC_BLACKLIST);
		TRANSFORMS.RegisterMap(class_2960.method_60656("charset_remap"),       CharRemapTransform.MAPCODEC);
		TRANSFORMS.RegisterMap(class_2960.method_60656("remap"),               RemapTransform.MAPCODEC);
		TRANSFORMS.RegisterMap(class_2960.method_60656("regex"),               RegexTransform.MAPCODEC);

		NBT_INPUTS.RegisterUnit(class_2960.method_60656("auto"),            INbtInput.AUTO);
		NBT_INPUTS.RegisterUnit(class_2960.method_60656("primitive"),       INbtInput.PRIMITIVE);
		NBT_INPUTS.RegisterUnit(class_2960.method_60656("string"),          INbtInput::String);
		NBT_INPUTS.RegisterUnit(class_2960.method_60656("number"),          INbtInput::Number);
		NBT_INPUTS.RegisterUnit(class_2960.method_60656("identifier"),      INbtInput::Identifier);
		NBT_INPUTS.RegisterUnit(class_2960.method_60656("rich_text"),       INbtInput::RichText);
		NBT_INPUTS.RegisterUnit(class_2960.method_60656("rich_text_array"), INbtInput::RichTextArray);
	}
}
