package fr.estecka.variantscit.mixin;

import java.util.Map;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_324;
import net.minecraft.class_3695;
import net.minecraft.class_793;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import fr.estecka.variantscit.VariantsCitMod;

@Mixin(class_1088.class)
public class ModelLoaderMixin
{
	@Shadow private @Final Map<class_2960, class_1100> unbakedModels;
	@Shadow private @Final Map<class_1091, class_1100> modelsToBake;

	static private final String ARBITRARY_MODEL = """
		{
			"parent": "%s",
			"textures": {
				"layer0": "%s"
			}
		}
	""";

	@Unique
	private void AddFromTexture(class_1091 modelId, class_2960 parent) {
		class_793 model = class_793.method_3430(ARBITRARY_MODEL.formatted(parent.toString(), modelId.comp_2875().toString()));
		this.unbakedModels.put(modelId.comp_2875(), model);
		this.modelsToBake.put(modelId, model);
	}

	/**
	 * Injected right before the post-processing of `modelsToBake`.
	 */
	@Inject( method="<init>", at=@At(value="INVOKE", target="java/util/Map.values ()Ljava/util/Collection;") )
	private void	AddVariantModels(class_324 _0, class_3695 profiler, Map<?,?> _2, Map<?,?> _3, CallbackInfo ci)
	{
		profiler.method_15405("variants-cit");
		var models = VariantsCitMod.GetModelsToCreate();
		VariantsCitMod.LOGGER.info("Creating {} item models from textures...", models.size());
		for (var entry : VariantsCitMod.GetModelsToCreate().entrySet())
			this.AddFromTexture(entry.getKey(), entry.getValue());
	}
}
