package fr.estecka.variantscit;

import java.util.Map;
import net.minecraft.class_1091;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import fr.estecka.variantscit.api.ICitModule;
import fr.estecka.variantscit.api.IVariantManager;

public final class VariantLibrary
implements IVariantManager
{
	@Deprecated
	private ICitModule module;

	private final @Nullable class_1091 fallbackModel;
	/**
	 * Maps variant IDs to model IDs.
	 */
	private final Map<class_2960, class_1091> variantModels;
	private final Map<String, class_1091> specialModels;

	public VariantLibrary(
		@Nullable class_1091 fallbackModel,
		Map<class_2960, class_1091> variantModels,
		Map<String, class_1091> specialModels
	){
		this.fallbackModel = fallbackModel;
		this.variantModels = variantModels;
		this.specialModels = specialModels;
	}

	@Deprecated
	public void SetModule(ICitModule module){
		this.module = module;
	}

	@Deprecated
	@Override
	public @Nullable class_1091 GetModelVariantForItem(class_1799 stack){
		return GetVariantModel(module.GetItemVariant(stack));
	}

	@Override
	public boolean HasVariantModel(class_2960 variant){
		return this.variantModels.containsKey(variant);
	}

	@Override
	public @Nullable class_1091 GetVariantModel(class_2960 variant){
		if (variant == null)
			return null;
		else
			return this.variantModels.getOrDefault(variant, this.fallbackModel);
	}

	@Override
	public @Nullable class_1091 GetSpecialModel(String key){
		return this.specialModels.get(key);
	}

	public int GetVariantCount(){
		return this.variantModels.size();
	}
}
