package fr.estecka.variantscit;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.minecraft.class_1091;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_9334;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.mojang.serialization.MapCodec;
import fr.estecka.variantscit.modules.*;


public class VariantsCitMod
implements ClientModInitializer, PreparableModelLoadingPlugin<ModuleLoader.Result>
{
	static public final String MODID = "variants-cit";
	public static final Logger LOGGER = LoggerFactory.getLogger(MODID);

	static public int reloadcount = 0;
	static private Map<class_1792, IItemModelProvider> MODULES = new HashMap<>();
	static private Map<class_1091, class_2960> AUTOGEN = new HashMap<>();

	static public @Nullable IItemModelProvider GetModule(class_1792 itemType){
		return MODULES.get(itemType);
	}

	static public Map<class_1091, class_2960> GetModelsToCreate(){
		return Map.copyOf(AUTOGEN);
	}

	@Override
	public void onInitializeClient(){
		PreparableModelLoadingPlugin.register(new ModuleLoader(), this);

		ModuleRegistry.Register(class_2960.method_60656("axolotl_variant"), AxolotlBucketModule.CODEC);
		ModuleRegistry.Register(class_2960.method_60656("block_entity_data"), ComponentDataModule.CreateLegacyCodec(class_9334.field_49611));
		ModuleRegistry.Register(class_2960.method_60656("bucket_entity_data"), ComponentDataModule.CreateLegacyCodec(class_9334.field_49610));
		ModuleRegistry.Register(class_2960.method_60656("component_data"), ComponentDataModule.CODEC);
		ModuleRegistry.Register(class_2960.method_60656("component_format"), MultiComponentFormatModule.CODEC);
		ModuleRegistry.Register(class_2960.method_60656("custom_data"), ComponentDataModule.CreateLegacyCodec(class_9334.field_49628));
		ModuleRegistry.Register(class_2960.method_60656("custom_name"), CustomNameModule.CODEC);
		ModuleRegistry.Register(class_2960.method_60656("durability"), DurabilityModule.CODEC);
		ModuleRegistry.Register(class_2960.method_60656("enchantment"), EnchantmentModule.CreateCodec(class_9334.field_49633));
		ModuleRegistry.Register(class_2960.method_60656("entity_data"), ComponentDataModule.CreateLegacyCodec(class_9334.field_49609));
		ModuleRegistry.Register(class_2960.method_60656("instrument"), new GoatHornModule());
		ModuleRegistry.Register(class_2960.method_60656("item_count"), ItemCountModule.CODEC);
		ModuleRegistry.Register(class_2960.method_60656("jukebox_playable"), new MusicDiscModule());
		ModuleRegistry.Register(class_2960.method_60656("painting_variant"), new PaintingVariantModule());
		ModuleRegistry.Register(class_2960.method_60656("potion_effect"), new PotionEffectModule());
		ModuleRegistry.Register(class_2960.method_60656("potion_type"), new PotionTypeModule());
		ModuleRegistry.Register(class_2960.method_60656("stored_enchantment"), EnchantmentModule.CreateCodec(class_9334.field_49643));
		ModuleRegistry.Register(class_2960.method_60656("stored_enchantments"), MapCodec.unit(() -> {
			LOGGER.warn("Module name `stored_enchantments` (plural) is being deprecated. use `stored_enchantment` (singular) instead.");
			return new EnchantmentModule(class_9334.field_49643, Map.of(), Optional.empty());
		}));
		ModuleRegistry.Register(class_2960.method_60656("trim"), new TrimModule());
		ModuleRegistry.Register(class_2960.method_60656("trim_pattern"), new TrimPatternModule());
		ModuleRegistry.Register(class_2960.method_60656("trim_material"), new TrimPatternModule());

		class_5272.method_27881(class_2960.method_60656("bucket_entity_age"), new BucketAgePredicate());
		class_5272.method_27879(class_1802.field_8598, class_2960.method_60656("level"), new EnchantedBookLevelPredicate());
		var potionPredicate = new PotionLevelPredicate();
		class_5272.method_27879(class_1802.field_8574, class_2960.method_60656("amplifier"), potionPredicate);
		class_5272.method_27879(class_1802.field_8436, class_2960.method_60656("amplifier"), potionPredicate);
		class_5272.method_27879(class_1802.field_8150, class_2960.method_60656("amplifier"), potionPredicate);
	}

	@Override
	public void onInitializeModelLoader(ModuleLoader.Result result, ModelLoadingPlugin.Context pluginContext){
		++reloadcount;
		result.modelAggregator.modelsToLoad.stream().map(class_1091::comp_2875).forEach(pluginContext::addModels);

		for (var e : result.uniqueModules.entrySet())
			LOGGER.info("Found {} variants for VCIT module {}", e.getValue().library().GetVariantCount(), e.getKey());

		AUTOGEN = result.modelAggregator.modelsToCreate;
		MODULES = new HashMap<>();
		for (var entry : result.modulesPerItem.entrySet()){
			MODULES.put(
				entry.getKey().comp_349(),
				IItemModelProvider.OfList( entry.getValue().stream().map(meta->meta.bakedModule()).toList() )
			);
		}
	}

}
