package fr.estecka.variantscit.format.properties;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.format.INbtInput;
import fr.estecka.variantscit.format.IStringTransform;
import fr.estecka.variantscit.format.NbtAdapter;
import fr.estecka.variantscit.format.NbtPath;

public record ItemComponentProperty(
	class_9331<?> componentType,
	NbtAdapter nbtAdapter
)
implements IStringProperty
{
	static public final MapCodec<ItemComponentProperty> MAP_CODEC = RecordCodecBuilder.mapCodec(builder->builder
		.group(
			class_7923.field_49658.method_39673().fieldOf("componentType").forGetter(ItemComponentProperty::componentType),
			NbtAdapter.MAPCODEC.forGetter(ItemComponentProperty::nbtAdapter)
		)
		.apply(builder, ItemComponentProperty::new)
	);

	static public final Codec<TransformableProperty<ItemComponentProperty>> MONOSTRING_DECODER = Codec.STRING.flatXmap(
		ItemComponentProperty::MonostringParse,
		__->DataResult.error(()->"Encoding not supported")
	);

	@Override
	public int GetPropertyHash(class_1799 stack){
		Object cmp = stack.method_57824(this.componentType);
		return (cmp!=null) ? cmp.hashCode() : 0;
	}

	@Override
	public Object GetReference(class_1799 stack) {
		return stack.method_57824(this.componentType);
	}

	@Override
	public String GetPropertyString(class_1799 stack){
		class_2520 nbt = CodecUtil.GetComponentNbt(stack, this.componentType);
		if (nbt == null)
			return null;

		String result = this.nbtAdapter.ResolveData(nbt);
		return result;
	}

	static private DataResult<TransformableProperty<ItemComponentProperty>> MonostringParse(String input){
		int pathLocation;
		for (pathLocation = 0; pathLocation<input.length(); pathLocation++){
			char c = input.charAt(pathLocation);
			if (c == '.' || !class_2960.method_12831(c))
				break;
		}

		String s_component = input.substring(0, pathLocation);
		String s_path      = input.substring(pathLocation);

		var r_path = (!s_path.isEmpty()) ? NbtPath.Parse(s_path) : DataResult.success(NbtPath.IDENTITY);
		var r_component = class_7923.field_49658.method_39673().decode(class_2509.field_11560, class_2519.method_23256(s_component)).map(Pair::getFirst);

		if (r_path.isError())
			return r_path.map(__->null);

		if (r_component.isError())
			return r_component.map(__->null);

		NbtPath path = r_path.getOrThrow();
		class_9331<?> component = r_component.getOrThrow();

		return DataResult.success(new TransformableProperty<>(
			new ItemComponentProperty(component, new NbtAdapter(path, INbtInput.AUTO)),
			IStringTransform.SANITIZE_AUTO,
			Optional.empty()
		));
	}
}
