/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.api.IVariantManager;
import fr.estecka.variantscit.format.properties.IntegerComponentProperty;
import fr.estecka.variantscit.modules.AMultiComponentCachingModule;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1091;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class DurabilityModule
extends AMultiComponentCachingModule {
    public static final MapCodec<DurabilityModule> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("debug", (Object)false).forGetter(o -> o.debug), (App)CodecUtil.IDENTIFIER_NAMESPACE.optionalFieldOf("namespace", (Object)"minecraft").forGetter(o -> o.namespace), (App)class_5699.field_33441.optionalFieldOf("scale").forGetter(o -> o.scale)).apply((Applicative)builder, DurabilityModule::new));
    private final String namespace;
    private final Optional<Integer> scale;

    public DurabilityModule(boolean debug, String namespace, Optional<Integer> scale) {
        super(debug, Stream.of(IntegerComponentProperty.DAMAGE, IntegerComponentProperty.MAX_DAMAGE));
        this.namespace = namespace;
        this.scale = scale;
    }

    @Override
    @Nullable
    public class_1091 RecomputeItemModel(class_1799 stack, IVariantManager library) {
        Integer max = (Integer)stack.method_57824(class_9334.field_50072);
        if (max == null) {
            return null;
        }
        int damage = (Integer)stack.method_57824(class_9334.field_49629);
        int durability = Math.clamp((long)(max - damage), 0, max);
        if (this.scale.isPresent()) {
            durability *= this.scale.get().intValue();
            durability += max - 1;
            durability /= max.intValue();
            max = this.scale.get();
        }
        for (int i = durability; i <= max; ++i) {
            class_2960 variantId = class_2960.method_60655((String)this.namespace, (String)String.valueOf(i));
            if (!library.HasVariantModel(variantId)) continue;
            return library.GetVariantModel(variantId);
        }
        return null;
    }
}

