/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.api.IVariantManager;
import fr.estecka.variantscit.modules.AComponentCachingModule;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1091;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class EnchantmentModule
extends AComponentCachingModule<class_9304> {
    private final Map<class_2960, Integer> precondition;
    private final Optional<String> separator;

    public static final MapCodec<EnchantmentModule> CreateCodec(class_9331<class_9304> targetComponent) {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.INT).optionalFieldOf("requiredEnchantments", Map.of()).forGetter(o -> o.precondition), (App)Codec.STRING.optionalFieldOf("levelSeparator").forGetter(o -> o.separator)).apply((Applicative)builder, (pre, sep) -> new EnchantmentModule(targetComponent, (Map<class_2960, Integer>)pre, (Optional<String>)sep)));
    }

    public EnchantmentModule(class_9331<class_9304> component, Map<class_2960, Integer> precondition, Optional<String> separator) {
        super(component);
        this.separator = separator;
        this.precondition = precondition;
    }

    @Override
    public class_1091 GetModelForComponent(class_9304 enchants, IVariantManager library) {
        if (enchants == null || enchants.method_57543() || !this.MatchesPrecondition(enchants)) {
            return null;
        }
        if (enchants.method_57541() > this.precondition.size() + 1 && null != library.GetSpecialModel("multi")) {
            return library.GetSpecialModel("multi");
        }
        Object2IntMap.Entry<class_6880<class_1887>> bestFit = this.GetBestEnchant(enchants, library);
        if (bestFit == null) {
            return null;
        }
        return this.GetEnchantModel(bestFit, library);
    }

    private boolean MatchesPrecondition(class_9304 component) {
        Object2IntOpenHashMap enchants = new Object2IntOpenHashMap();
        for (Object2IntMap.Entry entry : component.method_57539()) {
            enchants.put((Object)((class_5321)((class_6880)entry.getKey()).method_40230().get()).method_29177(), entry.getIntValue());
        }
        for (Map.Entry entry : this.precondition.entrySet()) {
            if (enchants.getInt(entry.getKey()) >= (Integer)entry.getValue()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private Object2IntMap.Entry<class_6880<class_1887>> GetBestEnchant(class_9304 enchants, IVariantManager library) {
        Object2IntMap.Entry bestFit = null;
        for (Object2IntMap.Entry enchant : enchants.method_57539()) {
            if (this.precondition.containsKey(((class_5321)((class_6880)enchant.getKey()).method_40230().get()).method_29177()) || this.CompareEnchants((Object2IntMap.Entry<class_6880<class_1887>>)enchant, bestFit, library) <= 0) continue;
            bestFit = enchant;
        }
        return bestFit;
    }

    private int CompareEnchants(Object2IntMap.Entry<class_6880<class_1887>> a, Object2IntMap.Entry<class_6880<class_1887>> b, IVariantManager library) {
        int result = 0;
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        result = Boolean.compare(this.HasVariantModel(a, library), this.HasVariantModel(b, library));
        if (result != 0) {
            return result;
        }
        result = ((class_1887)((class_6880)a.getKey()).comp_349()).comp_2688().method_40247() - ((class_1887)((class_6880)b.getKey()).comp_349()).comp_2688().method_40247();
        if (result != 0) {
            return result;
        }
        result = a.getIntValue() - b.getIntValue();
        if (result != 0) {
            return result;
        }
        return result;
    }

    private class_1091 GetEnchantModel(Object2IntMap.Entry<class_6880<class_1887>> enchant, IVariantManager library) {
        class_2960 variantId = ((class_5321)((class_6880)enchant.getKey()).method_40230().get()).method_29177();
        if (this.separator.isPresent()) {
            int level = enchant.getIntValue();
            class_2960 baseId = variantId.method_48331(this.separator.get());
            for (int i = level; 0 <= i; --i) {
                class_2960 leveledId = baseId.method_48331(String.valueOf(i));
                if (!library.HasVariantModel(leveledId)) continue;
                variantId = leveledId;
                break;
            }
        }
        return library.GetVariantModel(variantId);
    }

    private boolean HasVariantModel(Object2IntMap.Entry<class_6880<class_1887>> enchant, IVariantManager library) {
        return null != this.GetEnchantModel(enchant, library);
    }
}

