package fr.estecka.variantscit.mixin;

import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_10430;
import net.minecraft.class_10434;
import net.minecraft.class_10521;
import net.minecraft.class_1092;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3302;
import net.minecraft.class_793;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import fr.estecka.variantscit.reload.ModuleLoader;
import fr.estecka.variantscit.reload.VariantAggregator;
import fr.estecka.variantscit.VariantsCitMod;

@Unique
@Mixin(class_1092.class)
public class BakedModelManagerMixin
{
	/**
	 * I could probably use the constructor for JsonUnbakedModel instead, but it
	 * is unclear how parent-child inheritance works with it.
	 */
	static private final String ARBITRARY_MODEL = """
		{
			"parent": "%s",
			"textures": {
				"layer0": "%s"
			}
		}
	""";

	static private class_1100 ModelFromTexture(class_2960 assetId, class_2960 parent) {
		StringReader reader = new StringReader(ARBITRARY_MODEL.formatted(parent.toString(), assetId.toString()));
		class_793 model = class_793.method_3437(reader);
		return model;
	}

	static private class_10434 ItemFromModel(class_2960 assetId) {
		var unbaked = new class_10430.class_10431(assetId, List.of());
		var properties = new class_10434.class_10543(true, false);
		return new class_10434(unbaked, properties);
	}

	@Inject( method="reload", at=@At("HEAD") )
	private void reload(CallbackInfoReturnable<?> ci, @Local(argsOnly=true) class_3302.class_11558 store, @Share("result") LocalRef<VariantAggregator> resultRef){
		ModuleLoader.Result result = ModuleLoader.ReloadModules(store.method_72361());
		resultRef.set(result.variantAggregator);
		VariantsCitMod.OnResourceReload(result);
	}

	@ModifyExpressionValue( method="reload", at=@At(value="INVOKE", target="net/minecraft/client/render/model/BakedModelManager.reloadModels(Lnet/minecraft/resource/ResourceManager;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"))
	static private CompletableFuture<Map<class_2960,class_1100>> AddVariantModels(CompletableFuture<Map<class_2960,class_1100>> original, @Share("result") LocalRef<VariantAggregator> resultRef) {
		return original.thenApply( (allModels)->{
			allModels = new HashMap<class_2960, class_1100>(allModels);
	
			Map<class_2960,VariantAggregator.ModelToCreate> models = resultRef.get().modelsToCreate;
			VariantsCitMod.LOGGER.info("Creating {} models from textures...", models.size());
			for (var entry : models.entrySet()){
				class_2960 assetId = entry.getKey().method_45138("item/");
				allModels.put(assetId, ModelFromTexture(assetId, entry.getValue().parent()));
			}
	
			return allModels;
		});
	}

	@ModifyExpressionValue( method="reload", at=@At(value="INVOKE", target="net/minecraft/client/item/ItemAssetsLoader.load(Lnet/minecraft/resource/ResourceManager;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"))
	static private CompletableFuture<class_10521.class_10522> AddVariantItems(CompletableFuture<class_10521.class_10522> original, @Share("result") LocalRef<VariantAggregator> resultRef) {
		return original.thenApply( (result)->{
			var allItems = new HashMap<class_2960, class_10434>(result.comp_3426());
		
			Set<class_2960> items = resultRef.get().itemStatesToCreate;
			VariantsCitMod.LOGGER.info("Creating {} items from models...", items.size());
			for (class_2960 assetId : items){
				allItems.put(assetId, ItemFromModel(assetId.method_45138("item/")));
			}
			return new class_10521.class_10522(allItems);
		});
	}
}
