package fr.estecka.variantscit.modules;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import fr.estecka.variantscit.commands.CommandLogger;

public interface IBakedModule
{
	class_2960 GetModelForItem(class_1799 stack);

	static public IBakedModule OfList(List<? extends IBakedModule> modules){
		if (modules.isEmpty())
			return __->null;
		else if (modules.size() == 1)
			return modules.get(0);

		return (class_1799 stack)->{
			for (var m : modules){
				class_2960 id = m.GetModelForItem(stack);
				if (id != null)
					return id;
			}

			return null;
		};
	}

	default void Summary(CommandLogger logger){
		logger.Error("This module type does not support `summary`. Please report this issue.");
	}

	default void Dump(CommandLogger logger){
		logger.Error("This module type does not support `dump`. Please report this issue.");
	}

	default class_2960 Walkthrough(CommandLogger logger, class_1799 stack) {
		logger.Error("This module type does not support `walkthrough`. Please report this issue.");
		return this.GetModelForItem(stack);
	}
}
