package fr.estecka.variantscit.modules.libraries;

import fr.estecka.variantscit.commands.CommandLogger;
import fr.estecka.variantscit.modules.IBakedModule;
import fr.estecka.variantscit.modules.libraries.IDebuggableLibrary.Snitch;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class GenericBakedModule<L>
implements IBakedModule
{
	public final L library;
	private final IDebuggableLibrary<L> debug;
	public final IGenericCitModule<L> logic;

	public GenericBakedModule(IDebuggableLibrary<L> library, IGenericCitModule<L> logic){
		this.library = library.GetLibrary();
		this.debug = library;
		this.logic = logic;
	}

	@Override
	public class_2960 GetModelForItem(class_1799 stack) {
		return logic.GetItemModel(stack, library);
	}

	@Override
	public void Summary(CommandLogger logger) {
		debug.Summary(logger);
	}

	@Override
	public void Dump(CommandLogger logger) {
		debug.Dump(logger);
	}

	@Override
	public class_2960 Walkthrough(CommandLogger logger, class_1799 stack) {
		Snitch<L> snitch = this.debug.CreateSnitch(logger);
		class_2960 result = this.logic.Walkthrough(stack, snitch.GetLibrary(), logger);
		snitch.PrintConclusion();
		return result;
	}
}
