/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modules.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.MultiPropertyCache;
import fr.estecka.variantscit.commands.CommandLogger;
import fr.estecka.variantscit.format.properties.IntegerComponentProperty;
import fr.estecka.variantscit.modules.libraries.ILinearLibrary;
import fr.estecka.variantscit.modules.libraries.LinearLibrary;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class DurabilityModule
implements LinearLibrary.ILinearCitModule {
    public static final MapCodec<DurabilityModule> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("debug", (Object)false).forGetter(o -> o.cache.debug), (App)CodecUtil.IDENTIFIER_NAMESPACE.optionalFieldOf("namespace", (Object)"minecraft").forGetter(DurabilityModule::GetNamespace), (App)class_5699.field_33441.optionalFieldOf("scale").forGetter(o -> o.scale)).apply((Applicative)builder, DurabilityModule::new));
    private final MultiPropertyCache cache;
    private final String namespace;
    private final Optional<Integer> scale;

    public DurabilityModule(boolean debug, String namespace, Optional<Integer> scale) {
        this.cache = new MultiPropertyCache(debug, Stream.of(IntegerComponentProperty.DAMAGE, IntegerComponentProperty.MAX_DAMAGE));
        this.namespace = namespace;
        this.scale = scale;
    }

    @Override
    public String GetNamespace() {
        return this.namespace;
    }

    @Override
    @Nullable
    public class_2960 GetItemModel(class_1799 stack, ILinearLibrary library) {
        return this.cache.ComputeIfAbsent(stack, __ -> this.RecomputeItemModel(stack, library));
    }

    @Nullable
    public class_2960 RecomputeItemModel(class_1799 stack, ILinearLibrary library) {
        Integer max = (Integer)stack.method_58694(class_9334.field_50072);
        if (max == null) {
            return null;
        }
        int damage = (Integer)stack.method_58694(class_9334.field_49629);
        int durability = Math.clamp((long)(max - damage), 0, max);
        if (this.scale.isPresent()) {
            durability *= this.scale.get().intValue();
            durability += max - 1;
            durability /= max.intValue();
        }
        return library.GetOrGreater(durability);
    }

    @Override
    @Nullable
    public class_2960 Walkthrough(class_1799 stack, ILinearLibrary library, CommandLogger logger) {
        return this.RecomputeItemModel(stack, library);
    }
}

