/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.commands.CommandLogger;
import fr.estecka.variantscit.commands.ModuleContextArgumentType;
import fr.estecka.variantscit.modules.IBakedModule;
import fr.estecka.variantscit.reload.EModuleContext;
import fr.estecka.variantscit.reload.MetaModule;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

public class ModuleCommands {
    public static final class_2960 ID = class_2960.method_60655((String)"variants-cit", (String)"modules");
    public static final String CONTEXT_ARG = "context";
    public static final String MODULE_ARG = "module id";

    public static void Register() {
        ClientCommandRegistrationCallback.EVENT.register(ID, ModuleCommands::RegisterWith);
    }

    public static void RegisterWith(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        RequiredArgumentBuilder module = (RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)ClientCommandManager.argument((String)MODULE_ARG, (ArgumentType)class_2232.method_9441()).suggests(ModuleCommands::ModuleAutofill).then(ClientCommandManager.literal((String)"dump").executes(c -> ModuleCommands.Execute((CommandContext<FabricClientCommandSource>)c, ModuleCommands::Dump)))).then(ClientCommandManager.literal((String)"summary").executes(c -> ModuleCommands.Execute((CommandContext<FabricClientCommandSource>)c, ModuleCommands::Summary)))).then(ClientCommandManager.literal((String)"walkthrough").executes(c -> ModuleCommands.Execute((CommandContext<FabricClientCommandSource>)c, ModuleCommands::Walkthrough)));
        RequiredArgumentBuilder context = (RequiredArgumentBuilder)ClientCommandManager.argument((String)CONTEXT_ARG, (ArgumentType)ModuleContextArgumentType.moduleContext()).suggests(ModuleCommands::ContextAutofill).then((ArgumentBuilder)module);
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"variants-cit").then((ArgumentBuilder)context);
        dispatcher.register(root);
    }

    private static CompletableFuture<Suggestions> ContextAutofill(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        for (EModuleContext moduleContext : EModuleContext.values()) {
            builder.suggest(moduleContext.name);
        }
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> ModuleAutofill(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        EModuleContext moduleContext = ModuleContextArgumentType.getModuleContext(context, CONTEXT_ARG);
        Stream<class_2960> modules = VariantsCitMod.GetMeta().entrySet().stream().filter(entry -> {
            MetaModule meta = (MetaModule)entry.getValue();
            return switch (moduleContext) {
                default -> false;
                case EModuleContext.ITEM_MODEL -> meta.itemModule().isPresent();
                case EModuleContext.EQUIPPABLE -> meta.equipModule().isPresent();
            };
        }).map(Map.Entry::getKey);
        class_2172.method_9257(modules, (SuggestionsBuilder)builder);
        return builder.buildFuture();
    }

    private static int Execute(CommandContext<FabricClientCommandSource> context, IModuleCommand command) throws CommandSyntaxException {
        EModuleContext moduleContext = ModuleContextArgumentType.getModuleContext(context, CONTEXT_ARG);
        class_2960 moduleId = (class_2960)context.getArgument(MODULE_ARG, class_2960.class);
        MetaModule meta = VariantsCitMod.GetMeta().get(moduleId);
        IBakedModule module = VariantsCitMod.GetModule(moduleContext, moduleId);
        if (module == null) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("No such module: " + String.valueOf((Object)moduleContext) + " " + String.valueOf(moduleId))));
            return -1;
        }
        CommandLogger logger = new CommandLogger(context, moduleContext, meta);
        return command.Execute(context, logger, module);
    }

    private static int Dump(CommandContext<FabricClientCommandSource> context, CommandLogger logger, IBakedModule module) {
        module.Dump(logger);
        return 0;
    }

    private static int Summary(CommandContext<FabricClientCommandSource> context, CommandLogger logger, IBakedModule module) {
        module.Summary(logger);
        return 0;
    }

    private static int Walkthrough(CommandContext<FabricClientCommandSource> cmdCtx, CommandLogger logger, IBakedModule module) {
        class_2960 modelId;
        class_1799 stack = ((FabricClientCommandSource)cmdCtx.getSource()).getPlayer().method_6047();
        logger.Info("--------");
        logger.Info("Testing {} module {} on main-hand item: {} ({})", CommandLogger.PackData((Object)logger.moduleContext()), CommandLogger.PackData(logger.metamodule().id()).method_27692(class_124.field_1073), CommandLogger.ItemData(stack.method_7964()).method_27692(class_124.field_1073), CommandLogger.ItemData(stack.method_7909()));
        logger.Info("----");
        if (!logger.metamodule().targets().contains(stack.method_7909())) {
            logger.Info(class_124.field_1065, "[WARN] This module would normally not be applied to items of type {}", stack.method_7909());
        }
        if ((modelId = module.Walkthrough(logger, stack)) != null) {
            logger.Info("The module returned the model: {}", CommandLogger.PackData(modelId));
        } else {
            logger.Info("The module failed to apply to the item.");
        }
        return 0;
    }

    @FunctionalInterface
    private static interface IModuleCommand {
        public int Execute(CommandContext<FabricClientCommandSource> var1, CommandLogger var2, IBakedModule var3) throws CommandSyntaxException;
    }
}

