/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.VCitRegistries;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2509;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8824;

public interface INbtInput
extends Function<class_2520, String> {
    public static final INbtInput AUTO = INbtInput.Grouped(INbtInput::RichText, INbtInput::String, INbtInput::Number, INbtInput::RichTextArray);
    public static final INbtInput PRIMITIVE = INbtInput.Grouped(INbtInput::String, INbtInput::Number);
    public static final Codec<INbtInput> CODEC = VCitRegistries.NBT_INPUTS.codec;
    public static final Codec<INbtInput[]> ARRAY_CODEC = CodecUtil.OneOrMany(CODEC).xmap(list -> (INbtInput[])list.toArray(INbtInput[]::new), array -> List.of(array));
    public static final Codec<INbtInput> GROUP_CODEC = ARRAY_CODEC.xmap(INbtInput::Grouped, type -> {
        INbtInput[] iNbtInputArray;
        if (type instanceof Group) {
            Group group = (Group)type;
            iNbtInputArray = group.content();
        } else {
            INbtInput[] iNbtInputArray2 = new INbtInput[1];
            iNbtInputArray = iNbtInputArray2;
            iNbtInputArray2[0] = type;
        }
        return iNbtInputArray;
    });

    public static INbtInput Grouped(INbtInput ... group) {
        if (group.length == 1) {
            return group[0];
        }
        return new Group(group);
    }

    public static String String(class_2520 nbt) {
        String string;
        if (nbt instanceof class_2519) {
            class_2519 string2 = (class_2519)nbt;
            string = string2.method_10714();
        } else {
            string = null;
        }
        return string;
    }

    public static String Number(class_2520 nbt) {
        String string;
        if (nbt instanceof class_2514) {
            class_2514 number = (class_2514)nbt;
            string = number.method_10702().toString();
        } else {
            string = null;
        }
        return string;
    }

    public static String Identifier(class_2520 nbt) {
        class_2960 id;
        if (nbt instanceof class_2519 && null != (id = class_2960.method_12829((String)nbt.method_10714()))) {
            return id.toString();
        }
        return null;
    }

    public static String RichText(class_2520 nbt) {
        DataResult text = class_8824.field_46598.parse((DynamicOps)class_2509.field_11560, (Object)nbt);
        if (text.isSuccess()) {
            return ((class_2561)text.getOrThrow()).getString();
        }
        return null;
    }

    public static String RichTextArray(class_2520 nbt) {
        DataResult result = class_8824.field_46598.sizeLimitedListOf(256).parse((DynamicOps)class_2509.field_11560, (Object)nbt);
        if (!result.isSuccess()) {
            return null;
        }
        List lines = (List)result.getOrThrow();
        StringBuilder builder = new StringBuilder();
        for (class_2561 l : lines) {
            builder.append(l.getString());
            builder.append('\n');
        }
        return builder.toString();
    }

    public record Group(INbtInput[] content) implements INbtInput
    {
        @Override
        public String apply(class_2520 nbt) {
            for (int i = 0; i < this.content.length; ++i) {
                String result = (String)this.content[i].apply(nbt);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }
}

