package fr.estecka.variantscit;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_9334;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import fr.estecka.variantscit.api.ICitModule;
import fr.estecka.variantscit.format.INbtInput;
import fr.estecka.variantscit.format.IStringTransform;
import fr.estecka.variantscit.format.properties.*;
import fr.estecka.variantscit.format.transforms.*;
import fr.estecka.variantscit.modulebakers.*;
import fr.estecka.variantscit.modules.*;
import fr.estecka.variantscit.reload.UnbakedModule;

public final class VCitRegistries
{
	static public final DecodableRegistry<UnbakedModule<?>> MODULES = new DecodableRegistry<>("type", VCitRegistries::OptionalParameters);
	static public final DecodableRegistry<IStringProperty> ITEM_PROPERTIES = new DecodableRegistry<>("property", class_2960.method_60656("item_component"), TransformableProperty::CodecOf);
	static public final DecodableRegistry<IStringTransform> TRANSFORMS = new DecodableRegistry<>("function", class_2960.method_60656("regex"), OptionalTransform::CodecOf);
	static public final DecodableRegistry<INbtInput> NBT_INPUTS = new DecodableRegistry<>("type");

	static {
		RegisterSimpleModule(class_2960.method_60656("axolotl_variant"), AxolotlBucketModule.CODEC);
		RegisterSimpleModule(class_2960.method_60656("block_entity_data"), ComponentDataModule.CreateLegacyCodec(class_9334.field_49611));
		RegisterSimpleModule(class_2960.method_60656("bucket_entity_data"), ComponentDataModule.CreateLegacyCodec(class_9334.field_49610));
		RegisterSimpleModule(class_2960.method_60656("component_data"), ComponentDataModule.CODEC);
		RegisterSimpleModule(class_2960.method_60656("component_format"), MultiComponentFormatModule.CODEC);
		RegisterSimpleModule(class_2960.method_60656("custom_data"), ComponentDataModule.CreateLegacyCodec(class_9334.field_49628));
		RegisterSimpleModule(class_2960.method_60656("custom_name"), CustomNameModule.CODEC);
		RegisterBakedModule(class_2960.method_60656("durability"), DurabilityModule.CODEC, LinearLibrary::Bake);
		RegisterSimpleModule(class_2960.method_60656("enchantment"), EnchantmentModule.CreateCodec(class_9334.field_49633));
		RegisterBakedModule(class_2960.method_60656("enchantment_vector"), EnchantmentVectorModule.PARAM_MAPCODEC, EnchantmentVectorModule::Bake);
		RegisterSimpleModule(class_2960.method_60656("entity_data"), ComponentDataModule.CreateLegacyCodec(class_9334.field_49609));
		RegisterSimpleModule(class_2960.method_60656("instrument"), new GoatHornModule());
		RegisterBakedModule(class_2960.method_60656("item_count"), ItemCountModule.CODEC, LinearLibrary::Bake);
		RegisterSimpleModule(class_2960.method_60656("jukebox_playable"), new MusicDiscModule());
		RegisterSimpleModule(class_2960.method_60656("painting_variant"), new PaintingVariantModule());
		RegisterSimpleModule(class_2960.method_60656("potion_effect"), new PotionEffectModule());
		RegisterSimpleModule(class_2960.method_60656("potion_type"), new PotionTypeModule());
		RegisterSimpleModule(class_2960.method_60656("stored_enchantment"), EnchantmentModule.CreateCodec(class_9334.field_49643));
		RegisterSimpleModule(class_2960.method_60656("stored_enchantments"), CodecUtil.WithWarning(
			MapCodec.unit(new EnchantmentModule(class_9334.field_49643, Map.of(), Optional.empty())),
			"Module name `stored_enchantments` (plural) is being deprecated. use `stored_enchantment` (singular) instead."
		));
		RegisterBakedModule(class_2960.method_60656("stored_enchantment_vector"), EnchantmentVectorModule.PARAM_MAPCODEC, EnchantmentVectorModule::BakeStored);
		RegisterSimpleModule(class_2960.method_60656("trim"), new TrimModule());
		RegisterSimpleModule(class_2960.method_60656("trim_pattern"), new TrimPatternModule());
		RegisterSimpleModule(class_2960.method_60656("trim_material"), new TrimPatternModule());

		ITEM_PROPERTIES.RegisterUnit(class_2960.method_60656("axolotl_variant"), AxolotlVariantProperty.UNIT);
		ITEM_PROPERTIES.Register(class_2960.method_60656("bucket_entity_age"), EntityAgeMapProperty.MAP_CODEC, EntityAgeMapProperty.UNIT);
		ITEM_PROPERTIES.RegisterMap(class_2960.method_60656("item_component"), ItemComponentProperty.MAP_CODEC);
		ITEM_PROPERTIES.RegisterUnit(class_2960.method_60656("item_count"), new ItemCountProperty());
		ITEM_PROPERTIES.RegisterUnit(class_2960.method_60656("item_type"), new ItemTypeProperty());
		ITEM_PROPERTIES.RegisterUnit(class_2960.method_60656("painting_variant"), PaintingVariantProperty.UNIT);

		TRANSFORMS.RegisterUnit(class_2960.method_60656("noop"),               IStringTransform.NOOP);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("null"),               IStringTransform.NULL);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("lowercase"),          String::toLowerCase);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("discard_path"),       IStringTransform::DiscardPath);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("discard_namespace"),  IStringTransform::DiscardNamespace);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("sanitize"),           IStringTransform.SANITIZE);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("sanitize_path"),      IStringTransform.SANITIZE_PATH);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("sanitize_namespace"), IStringTransform.SANITIZE_NAMESPACE);
		TRANSFORMS.RegisterUnit(class_2960.method_60656("sanitize_auto"),      IStringTransform::AutoSanitize);
		TRANSFORMS.RegisterMap(class_2960.method_60656("test"),                TestTransform.MAPCODEC);
		TRANSFORMS.RegisterMap(class_2960.method_60656("successive"),          SuccessiveTransform.MAPCODEC);
		TRANSFORMS.RegisterMap(class_2960.method_60656("alternative"),         AlternativeTransform.MAPCODEC);
		TRANSFORMS.RegisterMap(class_2960.method_60656("whitelist"),           FilterlistTransform.MAPCODEC_WHITELIST);
		TRANSFORMS.RegisterMap(class_2960.method_60656("blacklist"),           FilterlistTransform.MAPCODEC_BLACKLIST);
		TRANSFORMS.RegisterMap(class_2960.method_60656("charset_remap"),       CharRemapTransform.MAPCODEC);
		TRANSFORMS.RegisterMap(class_2960.method_60656("remap"),               RemapTransform.MAPCODEC);
		TRANSFORMS.RegisterMap(class_2960.method_60656("regex"),               RegexTransform.MAPCODEC);

		NBT_INPUTS.RegisterUnit(class_2960.method_60656("auto"),            INbtInput.AUTO);
		NBT_INPUTS.RegisterUnit(class_2960.method_60656("primitive"),       INbtInput.PRIMITIVE);
		NBT_INPUTS.RegisterUnit(class_2960.method_60656("string"),          INbtInput::String);
		NBT_INPUTS.RegisterUnit(class_2960.method_60656("number"),          INbtInput::Number);
		NBT_INPUTS.RegisterUnit(class_2960.method_60656("identifier"),      INbtInput::Identifier);
		NBT_INPUTS.RegisterUnit(class_2960.method_60656("rich_text"),       INbtInput::RichText);
		NBT_INPUTS.RegisterUnit(class_2960.method_60656("rich_text_array"), INbtInput::RichTextArray);
	}

	static public <T> void RegisterBakedModule(class_2960 id, MapCodec<T> mapcodec, IModuleBaker<T> baker){
		MODULES.RegisterMap(id, mapcodec.xmap(
			parameters -> new UnbakedModule<>(baker, parameters),
			UnbakedModule::parameters
		));
	}

	static public void RegisterSimpleModule(class_2960 id, MapCodec<? extends ICitModule> mapcodec){
		RegisterBakedModule(id, mapcodec, GenericBakedModule::new);
	}

	static public void RegisterSimpleModule(class_2960 id, ICitModule unit){
		RegisterSimpleModule(id, MapCodec.unit(unit));
	}

	static private <T> MapDecoder<T> OptionalParameters(MapDecoder<T> mapcodec){
		return class_2487.field_25128
			.optionalFieldOf("parameters", new class_2487())
			.flatMap(nbt -> class_2509.field_11560.withParser(mapcodec.decoder()).apply(nbt))
			;
	}
}
