package fr.estecka.variantscit.format.properties;

import org.jetbrains.annotations.NotNull;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class EntityAgeMapProperty
extends AMonoComponentProperty<class_9279>
{
	static public final EntityAgeMapProperty UNIT = new EntityAgeMapProperty("", "_baby");

	static public final MapCodec<EntityAgeMapProperty> MAP_CODEC = RecordCodecBuilder.mapCodec(builder->
		builder.group(
			Codec.STRING.optionalFieldOf("adult", UNIT.adult).forGetter(o->o.adult),
			Codec.STRING.optionalFieldOf("baby", UNIT.baby).forGetter(o->o.baby)
		)
		.apply(builder, EntityAgeMapProperty::new)
	);

	private final String adult, baby;

	public EntityAgeMapProperty(String adult, String baby){
		super(class_9334.field_49610);
		this.adult = adult;
		this.baby = baby;
	}

	@Override
	public @NotNull String GetPropertyString(class_9279 bucket) {
		class_2487 nbt;

		// TODO: Directly access the Nbt if performances become a concern.
		if (bucket == null || (nbt=bucket.method_57461()) == null)
			return adult;

		float age = nbt.method_66563("Age", 0);
		return (age>=0) ? adult : baby;
	}
}
