package fr.estecka.variantscit.modulebakers;

import org.jetbrains.annotations.Nullable;
import fr.estecka.variantscit.LinearSnapMap;
import fr.estecka.variantscit.VariantLibrary;
import net.minecraft.class_2960;


public class LinearLibrary
{
	private final class_2960 fallback;
	private final LinearSnapMap<class_2960> modelLine = new LinearSnapMap<>();

	public LinearLibrary(VariantLibrary variantLibrary, String allowedNamespace){
		this.fallback = variantLibrary.fallbackModel();

		for (var variant : variantLibrary.variantModels().entrySet())
		if  (variant.getKey().method_12836().equals(allowedNamespace))
		{
			try {
				int magnitude = Integer.parseInt(variant.getKey().method_12832());
				this.modelLine.AddEntry(magnitude, variant.getValue());
			} catch (NumberFormatException err)
			{}
		}
	}

	private class_2960 Fallback(@Nullable class_2960 id){
		return (id != null) ? id : fallback;
	}

	public class_2960 GetOrLesser(int magnitude){
		return Fallback(this.modelLine.GetClosestValue(magnitude, -1));
	}

	public class_2960 GetOrGreater(int magnitude){
		return Fallback(this.modelLine.GetClosestValue(magnitude, +1));
	}


/******************************************************************************/
/* # Baking                                                                   */
/******************************************************************************/

	static public interface ILinearCitModule
	extends IGenericCitModule<LinearLibrary>
	{
		String GetNamespace();
	}

	static public GenericBakedModule<LinearLibrary> Bake(VariantLibrary library, ILinearCitModule logic){
		return new GenericBakedModule<>(new LinearLibrary(library, logic.GetNamespace()), logic);
	}

}
