/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format.transforms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.format.IStringTransform;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public record CharRemapTransform(Char2ObjectMap<@NotNull String> map) implements IStringTransform
{
    public static final MapCodec<CharRemapTransform> MAPCODEC = CharsetParams.MAPCODEC.xmap(CharsetParams::ToMap, CharsetParams::FromMap).xmap(CharRemapTransform::new, CharRemapTransform::map);

    @Override
    public String apply(String original) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < original.length(); ++i) {
            char inChar = original.charAt(i);
            String outStr = (String)this.map.get(inChar);
            if (outStr != null) {
                result.append(outStr);
                continue;
            }
            result.append(inChar);
        }
        return result.toString();
    }

    private record CharsetParams(String source, String destination, String delete, Map<Character, String> map) {
        public static final MapCodec<CharsetParams> MAPCODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("source").forGetter(CharsetParams::source), (App)Codec.STRING.fieldOf("destination").forGetter(CharsetParams::destination), (App)Codec.STRING.optionalFieldOf("delete", (Object)"").forGetter(CharsetParams::destination), (App)Codec.unboundedMap(CodecUtil.CHAR, (Codec)Codec.STRING).optionalFieldOf("map", Map.of()).forGetter(CharsetParams::map)).apply((Applicative)builder, CharsetParams::new));

        public static CharsetParams FromMap(Char2ObjectMap<@NotNull String> fullMap) {
            Object src = "";
            Object dst = "";
            Object del = "";
            HashMap<Character, String> paramMap = new HashMap<Character, String>();
            for (Char2ObjectMap.Entry entry : fullMap.char2ObjectEntrySet()) {
                char key = entry.getCharKey();
                String value = (String)entry.getValue();
                if (value.isEmpty()) {
                    del = (String)del + key;
                    continue;
                }
                if (value.length() >= 1) {
                    paramMap.put(Character.valueOf(key), value);
                    continue;
                }
                src = (String)src + key;
                dst = (String)dst + value;
            }
            return new CharsetParams((String)src, (String)dst, (String)del, paramMap);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public Char2ObjectMap<@NotNull String> ToMap() {
            int i;
            @NotNull Char2ObjectArrayMap fullMap = new Char2ObjectArrayMap();
            for (i = 0; i < this.source.length(); ++i) {
                char key = this.source.charAt(i);
                if (i < this.destination.length()) {
                    fullMap.put(key, (Object)this.destination.substring(i, i + 1));
                    continue;
                }
                fullMap.put(key, (Object)"");
            }
            for (i = 0; i < this.delete.length(); ++i) {
                fullMap.put(this.delete.charAt(i), (Object)"");
            }
            fullMap.putAll(this.map);
            return fullMap;
        }
    }
}

