/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.cryofloric_arts.hao111111111.item.item.SoulHateBook;

@OnlyIn(value=Dist.CLIENT)
public class SoulHateBookScreen
extends Screen {
    private static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("textures/gui/book.png");
    private static final ResourceLocation CUSTOM_BOOK_TEXTURE = new ResourceLocation("cryofloric_arts", "textures/gui/soul_hate_book.png");
    private final ItemStack bookStack;
    private int leftPos;
    private int topPos;
    private final int imageWidth = 192;
    private final int imageHeight = 192;

    public SoulHateBookScreen(ItemStack bookStack) {
        super((Component)Component.m_237115_((String)"item.cryofloric_arts.soul_hate_book"));
        this.bookStack = bookStack;
    }

    protected void m_7856_() {
        super.m_7856_();
        Objects.requireNonNull(this);
        this.leftPos = (this.f_96543_ - 192) / 2;
        Objects.requireNonNull(this);
        this.topPos = (this.f_96544_ - 192) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> {
            int currentPage = SoulHateBook.getCurrentPage(this.bookStack);
            if (currentPage > 0) {
                SoulHateBook.changePage(this.bookStack, currentPage - 1);
            }
        }).m_252987_(this.leftPos + 12, this.topPos + 156, 23, 13).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), button -> {
            int totalPages;
            int currentPage = SoulHateBook.getCurrentPage(this.bookStack);
            if (currentPage < (totalPages = SoulHateBook.getTotalPages(this.bookStack)) - 1) {
                SoulHateBook.changePage(this.bookStack, currentPage + 1);
            }
        }).m_252987_(this.leftPos + 157, this.topPos + 156, 23, 13).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        guiGraphics.m_280163_(CUSTOM_BOOK_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, 192, 192, 256, 256);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        int currentPage = SoulHateBook.getCurrentPage(this.bookStack) + 1;
        int totalPages = SoulHateBook.getTotalPages(this.bookStack);
        String pageText = currentPage + " / " + totalPages;
        Objects.requireNonNull(this);
        guiGraphics.m_280056_(this.f_96547_, pageText, this.leftPos + 192 / 2 - this.f_96547_.m_92895_(pageText) / 2, this.topPos + 16, 0x404040, false);
        this.renderPageContent(guiGraphics, SoulHateBook.getPageData(this.bookStack, currentPage - 1));
    }

    private void renderPageContent(GuiGraphics guiGraphics, CompoundTag pageData) {
        int contentLeft = this.leftPos + 36;
        int contentTop = this.topPos + 30;
        int lineHeight = 9;
        int threshold = this.bookStack.m_41784_().m_128451_("threshold");
        if (pageData.m_128441_("id")) {
            String blockId = pageData.m_128461_("id");
            int count = pageData.m_128451_("count");
            int color = count >= threshold ? 0xFF0000 : 0;
            String displayName = this.getLocalizedBlockName(blockId);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"item.cryofloric_arts.soul_hate_book.block_id"), contentLeft, contentTop, 0x404040, false);
            guiGraphics.m_280056_(this.f_96547_, displayName, contentLeft + 10, contentTop + lineHeight, color, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"item.cryofloric_arts.soul_hate_book.count"), contentLeft, contentTop + 3 * lineHeight, 0x404040, false);
            guiGraphics.m_280056_(this.f_96547_, String.valueOf(count), contentLeft + 10, contentTop + 4 * lineHeight, color, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"item.cryofloric_arts.soul_hate_book.threshold", (Object[])new Object[]{threshold}), contentLeft, contentTop + 6 * lineHeight, 0x404040, false);
            if (count >= threshold) {
                guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"item.cryofloric_arts.soul_hate_book.status.danger"), contentLeft, contentTop + 8 * lineHeight, 0xFF0000, false);
            } else {
                guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"item.cryofloric_arts.soul_hate_book.status.safe"), contentLeft, contentTop + 8 * lineHeight, 43520, false);
            }
        } else {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"item.cryofloric_arts.soul_hate_book.empty"), contentLeft, contentTop, 0x404040, false);
        }
    }

    private String getLocalizedBlockName(String blockId) {
        try {
            ResourceLocation resourceLocation = new ResourceLocation(blockId);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            if (block != null) {
                return block.m_49954_().getString();
            }
            String translationKey = "block." + resourceLocation.m_135827_() + "." + resourceLocation.m_135815_();
            MutableComponent translatedName = Component.m_237115_((String)translationKey);
            if (!translatedName.getString().equals(translationKey)) {
                return translatedName.getString();
            }
            return this.formatBlockId(blockId);
        }
        catch (Exception e) {
            return blockId;
        }
    }

    private String formatBlockId(String blockId) {
        String displayId = blockId;
        if (displayId.contains(":")) {
            displayId = displayId.substring(displayId.indexOf(":") + 1);
        }
        String[] words = displayId.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.length() <= 0) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return result.toString().trim();
    }

    public boolean m_7043_() {
        return false;
    }
}

