/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.effect.debuff;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.cryofloric_arts.hao111111111.config.ModConfig;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;

public class SoreRush
extends MobEffect {
    public SoreRush() {
        super(MobEffectCategory.HARMFUL, 9055202);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        ServerLevel serverLevel;
        PollenData pollenData;
        int pollenValue;
        if (entity.m_9236_().f_46443_) {
            return;
        }
        if (entity.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
            entity.m_21195_((MobEffect)this);
            return;
        }
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel && (pollenValue = (pollenData = PollenData.get(serverLevel = (ServerLevel)level)).getPollenValueAt(entity.m_20183_())) <= 100) {
            return;
        }
        if (entity.f_19797_ % 100 == 0) {
            float chance = 0.15f * (float)(amplifier + 1);
            if (entity.m_217043_().m_188501_() < chance) {
                this.explode(entity, amplifier);
            }
        }
    }

    private void explode(LivingEntity entity, int amplifier) {
        ServerLevel level = (ServerLevel)entity.m_9236_();
        float damage = 5.0f;
        level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 20, 1.0, 1.0, 1.0, 0.2);
        AABB area = new AABB(entity.m_20183_()).m_82400_(3.0);
        level.m_45976_(LivingEntity.class, area).forEach(target -> {
            if (target != entity) {
                if (!target.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
                    target.m_6469_(entity.m_269291_().m_269109_(), damage * 0.5f);
                }
                if (target.m_21023_((MobEffect)this)) {
                    target.m_21124_((MobEffect)this).m_19558_(new MobEffectInstance((MobEffect)this, target.m_21124_((MobEffect)this).m_19557_() + 500, amplifier, false, false, true));
                } else {
                    target.m_7292_(new MobEffectInstance((MobEffect)this, 500, 0, false, false, true));
                }
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 300, 0, false, false, true));
            }
        });
        PollenData pollenData = PollenData.get(level);
        pollenData.addPollen(level, new ChunkPos(entity.m_20183_()), 10);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public static void handleEntityDeath(LivingEntity entity) {
        if (entity.m_21023_((MobEffect)ModEffects.SORE_RUSH.get())) {
            int amplifier = entity.m_21124_((MobEffect)ModEffects.SORE_RUSH.get()).m_19564_();
            int dropCount = 0;
            for (float chance = 0.5f * (float)(amplifier + 1); chance > 0.0f; chance -= 1.0f) {
                if (!(entity.m_217043_().m_188501_() < Math.min(chance, 1.0f))) continue;
                ++dropCount;
            }
            if (dropCount > 0) {
                ItemEntity itemEntity = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack((ItemLike)ModItem.SORE_CLOUD_SUBSTANCE.get(), dropCount));
                entity.m_9236_().m_7967_((Entity)itemEntity);
            }
        }
    }

    public static void handleHurt(LivingEntity entity, float damageAmount) {
        if (entity.m_21023_((MobEffect)ModEffects.SORE_RUSH.get())) {
            int amplifier = entity.m_21124_((MobEffect)ModEffects.SORE_RUSH.get()).m_19564_();
            float chance = 0.3f + 0.1f * (float)amplifier;
            if (entity.m_217043_().m_188501_() < chance) {
                float damage = (float)(1.0 * (Double)ModConfig.SORE_RUSH_EXPLOSION_DAMAGE_MULTIPLIER.get());
                SoreRush.spreadDamage(entity, damageAmount * damage, amplifier);
            }
        }
    }

    private static void spreadDamage(LivingEntity source, float damage, int amplifier) {
        if (source.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)source.m_9236_();
        AABB area = new AABB(source.m_20183_()).m_82400_(3.0);
        level.m_45976_(LivingEntity.class, area).forEach(target -> {
            if (target != source && !target.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
                target.m_6469_(source.m_269291_().m_269109_(), damage);
                if (source.m_217043_().m_188501_() < 0.3f) {
                    if (target.m_21023_((MobEffect)ModEffects.SORE_RUSH.get())) {
                        target.m_21124_((MobEffect)ModEffects.SORE_RUSH.get()).m_19558_(new MobEffectInstance((MobEffect)ModEffects.SORE_RUSH.get(), target.m_21124_((MobEffect)ModEffects.SORE_RUSH.get()).m_19557_() + 200, amplifier, false, false, true));
                    } else {
                        target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SORE_RUSH.get(), 200, 0, false, false, true));
                    }
                }
            }
        });
    }
}

