/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.events;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.cryofloric_arts.hao111111111.effect.buff.FrostAvoidance;
import org.cryofloric_arts.hao111111111.effect.buff.FrozenEarthBlessing;
import org.cryofloric_arts.hao111111111.effect.buff.OverRooting;
import org.cryofloric_arts.hao111111111.effect.buff.SoulStrike;
import org.cryofloric_arts.hao111111111.effect.debuff.FrostPowder;
import org.cryofloric_arts.hao111111111.effect.debuff.SoreRush;

@Mod.EventBusSubscriber(modid="cryofloric_arts")
public class ModEventHandlers {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        OverRooting.handleEntityDeath(entity);
        FrostPowder.handleEntityDeath(entity);
        SoreRush.handleEntityDeath(entity);
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity killer = (LivingEntity)entity2;
            FrostPowder.handleKill(killer, entity);
            OverRooting.handleKill(killer, entity);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.getPersistentData().m_128441_("ResurrectedEntity")) {
            event.getDrops().clear();
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity victim = event.getEntity();
        Entity attackerEntity = event.getSource().m_7639_();
        SoulStrike.onLivingHurt(event);
        if (FrostAvoidance.shouldAvoidFrostDamage(victim, event.getSource())) {
            event.setCanceled(true);
            return;
        }
        FrozenEarthBlessing.handleDamage(victim, event.getAmount());
        if (attackerEntity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)attackerEntity;
            float newAmount = OverRooting.handleFrostDamageBonus(attacker, victim, event.getAmount());
            event.setAmount(newAmount);
            OverRooting.handleGroupAggro(victim, attacker);
        }
        SoreRush.handleHurt(victim, event.getAmount());
    }
}

