/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.blocks;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.cryofloric_arts.hao111111111.blockentity.WinterThornBlockEntity;
import org.cryofloric_arts.hao111111111.blocks.SnowfallTaroBlock;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.utils.DamageSourceUtil;
import org.jetbrains.annotations.NotNull;

public class WinterThornBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;

    public WinterThornBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_7892_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if ((Integer)state.m_61143_((Property)AGE) > 1) {
                if (livingEntity.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
                    return;
                }
                LivingEntity motherEntity = this.getMotherEntity(level, pos);
                if (motherEntity != null) {
                    livingEntity.m_6469_(DamageSourceUtil.getFreezeDamage(level, motherEntity), 1.0f);
                    if ((Integer)state.m_61143_((Property)AGE) == 3) {
                        livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROSTED.get(), 200, 0));
                    }
                } else {
                    livingEntity.m_6469_(DamageSourceUtil.getFreezeDamage(level, null), 1.0f);
                    if ((Integer)state.m_61143_((Property)AGE) == 3) {
                        livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROSTED.get(), 200, 0));
                    }
                }
            }
        }
    }

    public void m_213898_(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 3 && level.m_45524_(pos, 0) >= 9 && random.m_188503_(5) == 0) {
            LivingEntity mother = this.getMotherEntity((Level)level, pos);
            if (mother != null && mother.m_6084_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            } else if (age > 1) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age - 1)), 0);
            }
        }
    }

    public void m_214162_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if ((Integer)state.m_61143_((Property)AGE) > 1 && random.m_188503_(10) == 0) {
            double d0 = (double)pos.m_123341_() + random.m_188500_();
            double d1 = (double)pos.m_123342_() + 1.1;
            double d2 = (double)pos.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected boolean m_6266_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.m_204336_(BlockTags.f_144274_) || state.m_60713_(Blocks.f_50127_) || state.m_60713_(Blocks.f_152499_) || state.m_204336_(SnowfallTaroBlock.STONE) || state.m_60713_(Blocks.f_50080_) || state.m_204336_(BlockTags.f_13047_);
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        if (!(level instanceof Level)) {
            return false;
        }
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        return this.m_6266_(belowState, (BlockGetter)level, belowPos);
    }

    @Nullable
    private LivingEntity getMotherEntity(Level level, BlockPos pos) {
        LivingEntity livingEntity;
        ServerLevel serverLevel;
        Entity entity;
        WinterThornBlockEntity winterThornBE;
        UUID motherUUID;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WinterThornBlockEntity && (motherUUID = (winterThornBE = (WinterThornBlockEntity)blockEntity).getMotherUUID()) != null && level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(motherUUID)) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6084_()) {
            return livingEntity;
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_57282_) {
        p_57282_.m_61104_(new Property[]{AGE});
    }

    public boolean m_7370_(@NotNull LevelReader p_256056_, @NotNull BlockPos p_57261_, BlockState p_57262_, boolean p_57263_) {
        return (Integer)p_57262_.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(@NotNull Level p_222558_, @NotNull RandomSource p_222559_, @NotNull BlockPos p_222560_, @NotNull BlockState p_222561_) {
        return true;
    }

    public void m_214148_(ServerLevel p_222553_, @NotNull RandomSource p_222554_, @NotNull BlockPos p_222555_, BlockState p_222556_) {
        int i = Math.min(3, (Integer)p_222556_.m_61143_((Property)AGE) + 1);
        p_222553_.m_7731_(p_222555_, (BlockState)p_222556_.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

