/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.cryofloric_arts.hao111111111.attributes.ModAttributes;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.entity.custom.SnowfallTaroCreature;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.cryofloric_arts.hao111111111.utils.DamageSourceUtil;
import org.cryofloric_arts.hao111111111.world.biome.ModBiomes;
import org.cryofloric_arts.hao111111111.world.storage.InfectionResistanceData;

public class SoulDiveBeast
extends SnowfallTaroCreature {
    private static final String SOUL_VALUE_TAG = "SoulValue";
    private static final EntityDataAccessor<Boolean> DATA_IS_DIVING = SynchedEntityData.m_135353_(SoulDiveBeast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final ResourceLocation SOUL_CRUSHING_DAMAGE = DamageSourceUtil.SOUL_CRUSHING_DAMAGE;
    private int soulValue = 0;
    private int noActionTime = 0;
    private int diveCooldown = 0;
    private boolean shouldBeDiving = false;
    private int hurtCooldown = 0;
    @Nullable
    private LivingEntity experienceTarget;
    private int diveStateChangeCooldown = 0;
    @Nullable
    private LivingEntity lastAttacker;

    public SoulDiveBeast(EntityType<? extends Animal> type, Level level) {
        super(type, level, 0, 0);
        this.f_21364_ = 25;
        this.f_21342_ = new SoulDiveMoveControl(this);
        this.m_20242_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_DIVING, (Object)false);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22280_, 0.4).m_22268_((Attribute)ModAttributes.MAX_DAMAGE_RATE.get(), 0.4);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SoulDiveGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AbsorbExperienceGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CollectExperienceGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, this::shouldAttack));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    private boolean shouldAttack(LivingEntity target) {
        if (target == this) {
            return false;
        }
        if (target.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
            return false;
        }
        if (target.m_21214_() != null && target.m_21214_().m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
            return true;
        }
        if (target.m_21188_() != null && target.m_21188_().m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
            return true;
        }
        return this.m_21674_(target);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_(SOUL_VALUE_TAG, this.soulValue);
        compound.m_128379_("IsDiving", this.isDiving());
        compound.m_128405_("DiveCooldown", this.diveCooldown);
        compound.m_128379_("ShouldBeDiving", this.shouldBeDiving);
        compound.m_128405_("HurtCooldown", this.hurtCooldown);
        compound.m_128405_("DiveStateChangeCooldown", this.diveStateChangeCooldown);
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.soulValue = compound.m_128451_(SOUL_VALUE_TAG);
        this.setDiving(compound.m_128471_("IsDiving"));
        this.diveCooldown = compound.m_128451_("DiveCooldown");
        this.shouldBeDiving = compound.m_128471_("ShouldBeDiving");
        this.hurtCooldown = compound.m_128451_("HurtCooldown");
        this.diveStateChangeCooldown = compound.m_128451_("DiveStateChangeCooldown");
        this.m_147285_(this.m_9236_(), compound);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.diveCooldown > 0) {
            --this.diveCooldown;
        }
        if (this.hurtCooldown > 0) {
            --this.hurtCooldown;
        }
        if (this.diveStateChangeCooldown > 0) {
            --this.diveStateChangeCooldown;
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || this.m_5448_().m_213877_())) {
            this.m_6710_(null);
            this.shouldBeDiving = false;
        }
        if (this.experienceTarget != null && (!this.experienceTarget.m_6084_() || this.experienceTarget.m_213877_())) {
            this.experienceTarget = null;
            this.shouldBeDiving = false;
        }
        if (this.lastAttacker != null && (!this.lastAttacker.m_6084_() || this.lastAttacker.m_213877_())) {
            this.lastAttacker = null;
        }
        if (this.isDiving()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 3; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
                }
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5448_() != null && this.m_5448_().m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
            this.m_6710_(null);
            this.shouldBeDiving = false;
        }
        if (this.experienceTarget != null && this.experienceTarget.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
            this.experienceTarget = null;
            this.shouldBeDiving = false;
        }
        if (!this.m_9236_().f_46443_ && !this.isDiving() && this.shouldBeDiving && this.diveCooldown <= 0 && this.diveStateChangeCooldown <= 0) {
            if (this.m_5448_() != null || this.experienceTarget != null || this.lastAttacker != null) {
                this.setDiving(true);
                this.diveStateChangeCooldown = 10;
            } else {
                this.shouldBeDiving = false;
            }
        }
        this.noActionTime = this.m_5448_() == null && this.experienceTarget == null && this.lastAttacker == null && !this.isDiving() ? ++this.noActionTime : 0;
        if (!(this.m_9236_().f_46443_ || this.m_5448_() == null && this.experienceTarget == null && this.lastAttacker == null || this.isDiving() || this.diveCooldown > 0 || this.diveStateChangeCooldown > 0)) {
            this.shouldBeDiving = true;
        }
        if (!this.m_9236_().f_46443_ && this.lastAttacker != null && this.m_5448_() == null) {
            this.m_6710_(this.lastAttacker);
            this.shouldBeDiving = true;
        }
        if (!this.m_9236_().f_46443_ && this.hurtCooldown <= 0) {
            this.detectHurtEntities();
            this.hurtCooldown = 20;
        }
        if (!this.m_9236_().f_46443_ && this.getSoulValue() >= 10 && this.f_19796_.m_188503_(100000) == 0) {
            this.tryLayBulb();
        }
    }

    private void tryLayBulb() {
        if (!this.m_9236_().m_204166_(this.m_20183_()).m_203565_(ModBiomes.WHITE_BARRENS)) {
            return;
        }
        AABB area = new AABB(this.m_20183_()).m_82400_(64.0);
        List beasts = this.m_9236_().m_45976_(SoulDiveBeast.class, area);
        int bulbCount = 0;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.m_20183_().m_7918_(-16, -16, -16), (BlockPos)this.m_20183_().m_7918_(16, 16, 16))) {
            if (this.m_9236_().m_8055_(pos).m_60734_() != ModBlock.SOUL_TARO_BULB.get() || ++bulbCount < 1) continue;
            return;
        }
        if (beasts.size() <= 1) {
            this.setSoulValue(this.getSoulValue() - 10);
            BlockPos bulbPos = this.findSuitableBulbPosition();
            if (bulbPos != null) {
                this.m_9236_().m_7731_(bulbPos, ((Block)ModBlock.SOUL_TARO_BULB.get()).m_49966_(), 3);
                this.m_5496_(SoundEvents.f_12392_, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f);
            }
        }
    }

    private BlockPos findSuitableBulbPosition() {
        BlockPos currentPos = this.m_20183_();
        if (this.m_9236_().m_46859_(currentPos)) {
            return currentPos;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                BlockPos checkPos = currentPos.m_7918_(x, 0, z);
                if (!this.m_9236_().m_46859_(checkPos)) continue;
                return checkPos;
            }
        }
        return null;
    }

    private void detectHurtEntities() {
        AABB area = new AABB(this.m_20183_()).m_82400_(16.0);
        List entities = this.m_9236_().m_45976_(LivingEntity.class, area);
        for (LivingEntity entity : entities) {
            if (!(entity.m_21223_() < entity.m_21233_()) || entity == this || this.shouldAttack(entity) || entity.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) continue;
            this.experienceTarget = entity;
            this.shouldBeDiving = true;
            break;
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.equals(this.m_269291_().m_269318_())) {
            return false;
        }
        if (this.isDiving()) {
            return false;
        }
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            if (livingAttacker.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
                return super.m_6469_(source, amount);
            }
            this.m_6703_(livingAttacker);
            this.m_6925_(attacker.m_20148_());
            this.m_7870_(600);
            this.shouldBeDiving = true;
            this.m_6710_(livingAttacker);
            this.lastAttacker = livingAttacker;
            if (this.m_21566_() instanceof SoulDiveMoveControl) {
                ((SoulDiveMoveControl)this.m_21566_()).m_6849_(attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), 1.2);
            }
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_5829_() {
        return !this.isDiving();
    }

    public boolean m_6094_() {
        return !this.isDiving();
    }

    public boolean m_7337_(Entity entity) {
        return !this.isDiving() && super.m_7337_(entity);
    }

    protected void m_7324_(Entity entity) {
        if (!this.isDiving()) {
            super.m_7324_(entity);
        }
    }

    public boolean m_6673_(DamageSource source) {
        return this.isDiving() || super.m_6673_(source);
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6090_() {
        return this.isDiving();
    }

    public boolean m_142066_() {
        return !this.isDiving();
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.isDiving()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_6478_(MoverType pType, Vec3 pPos) {
        if (this.isDiving()) {
            this.m_6034_(this.m_20185_() + pPos.f_82479_, this.m_20186_() + pPos.f_82480_, this.m_20189_() + pPos.f_82481_);
        } else {
            super.m_6478_(pType, pPos);
        }
    }

    protected void m_20101_() {
        if (!this.isDiving()) {
            super.m_20101_();
        }
    }

    public boolean isDiving() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_DIVING);
    }

    public void setDiving(boolean diving) {
        boolean wasDiving = this.isDiving();
        this.f_19804_.m_135381_(DATA_IS_DIVING, (Object)diving);
        if (diving && !wasDiving) {
            this.m_21573_().m_26573_();
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 1.0f, 1.0f);
            this.f_19794_ = true;
        } else if (!diving && wasDiving) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 1.0f, 1.0f);
            this.f_19794_ = false;
            this.diveStateChangeCooldown = 20;
        }
    }

    public int getSoulValue() {
        return this.soulValue;
    }

    public void setSoulValue(int value) {
        this.soulValue = value;
    }

    public void addSoulValue(int amount) {
        this.soulValue += amount;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get()) && this.soulValue > 0) {
            if (itemStack.m_41720_() == ModItem.SOUL_SHARD.get() && !this.m_9236_().f_46443_) {
                --this.soulValue;
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.m_20000_((ItemLike)ModItem.SOUL_CRYSTAL.get(), 1);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_144054_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            if (itemStack.m_41720_() == ModItem.CONSTANT_CONGEALED_STONE.get() && !this.m_9236_().f_46443_) {
                --this.soulValue;
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                for (int i = 0; i < 5; ++i) {
                    this.m_20000_((ItemLike)ModItem.SOUL_CRYSTAL.get(), 1);
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_144054_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    static class SoulDiveMoveControl
    extends MoveControl {
        private final SoulDiveBeast beast;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private double speed;

        public SoulDiveMoveControl(SoulDiveBeast beast) {
            super((Mob)beast);
            this.beast = beast;
        }

        public void m_6849_(double x, double y, double z, double speed) {
            this.wantedX = x;
            this.wantedY = y;
            this.wantedZ = z;
            this.speed = speed;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            if (this.beast.isDiving()) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    Vec3 vec3 = new Vec3(this.wantedX - this.beast.m_20185_(), this.wantedY - this.beast.m_20186_(), this.wantedZ - this.beast.m_20189_());
                    double d0 = vec3.m_82553_();
                    if (d0 < 2.500000277905201E-7) {
                        this.beast.m_20256_(this.beast.m_20184_().m_82490_(0.5));
                        return;
                    }
                    vec3 = vec3.m_82541_().m_82490_(Math.min(d0, 1.0) * this.speed);
                    this.beast.m_20256_(this.beast.m_20184_().m_82490_(0.85).m_82549_(vec3));
                    if (d0 > 1.0E-5) {
                        double d1 = vec3.m_165924_();
                        this.beast.m_146922_((float)(Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.2957763671875) + 90.0f);
                        this.beast.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d1) * 57.2957763671875));
                    }
                } else {
                    this.beast.m_20256_(this.beast.m_20184_().m_82490_(0.85));
                }
            } else {
                super.m_8126_();
            }
        }
    }

    static class SoulDiveGoal
    extends Goal {
        private final SoulDiveBeast beast;
        private int diveTime;

        public SoulDiveGoal(SoulDiveBeast beast) {
            this.beast = beast;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.beast.diveCooldown > 0 || this.beast.diveStateChangeCooldown > 0) {
                return false;
            }
            return this.beast.isDiving();
        }

        public void m_8056_() {
            this.diveTime = 0;
        }

        public void m_8037_() {
            ++this.diveTime;
            LivingEntity target = this.beast.m_5448_();
            if (target == null) {
                target = this.beast.experienceTarget;
            }
            if (target == null) {
                target = this.beast.lastAttacker;
            }
            if (target != null && target.m_6084_() && !target.m_213877_()) {
                if (target.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
                    if (this.beast.m_5448_() == target) {
                        this.beast.m_6710_(null);
                    } else if (this.beast.experienceTarget == target) {
                        this.beast.experienceTarget = null;
                    } else if (this.beast.lastAttacker == target) {
                        this.beast.lastAttacker = null;
                    }
                    this.m_8041_();
                    return;
                }
                Vec3 targetPos = target.m_20182_();
                if (this.beast.m_21566_() instanceof SoulDiveMoveControl) {
                    ((SoulDiveMoveControl)this.beast.m_21566_()).m_6849_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 1.2);
                }
                if (this.beast.m_20280_((Entity)target) < 9.0) {
                    this.m_8041_();
                    if (this.beast.m_5448_() == target) {
                        this.beast.m_7327_((Entity)target);
                        if (this.beast.getSoulValue() > 0) {
                            this.releaseSoulSkill(target);
                        }
                    } else if (this.beast.experienceTarget == target) {
                        this.beast.experienceTarget = null;
                    } else if (this.beast.lastAttacker == target) {
                        this.beast.lastAttacker = null;
                    }
                }
            } else {
                this.m_8041_();
            }
        }

        public boolean m_8045_() {
            return this.beast.isDiving() && this.diveTime < 200;
        }

        public void m_8041_() {
            this.beast.setDiving(false);
            this.beast.shouldBeDiving = false;
            this.beast.diveCooldown = 40;
        }

        private void releaseSoulSkill(LivingEntity target) {
            AABB area = new AABB(this.beast.m_20183_()).m_82400_(8.0);
            List entities = this.beast.m_9236_().m_45976_(LivingEntity.class, area);
            for (LivingEntity entity : entities) {
                DamageSource soulCrushingDamage;
                ServerLevel serverLevel;
                if (entity == this.beast || !this.beast.m_21674_(entity)) continue;
                Level level = entity.m_9236_();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    soulCrushingDamage = new DamageSource((Holder)serverLevel.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)SOUL_CRUSHING_DAMAGE)));
                } else {
                    soulCrushingDamage = entity.m_269291_().m_269264_();
                }
                entity.m_6469_(soulCrushingDamage, 20.0f);
                level = this.beast.m_9236_();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    InfectionResistanceData infectionData = InfectionResistanceData.get(serverLevel);
                    BlockPos beastPos = this.beast.m_20183_();
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            BlockPos checkPos = beastPos.m_7918_(x, 0, z);
                            if (!serverLevel.m_46749_(checkPos)) continue;
                            BlockState checkState = serverLevel.m_8055_(checkPos);
                            String blockId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)checkState.m_60734_())).toString();
                            int count = infectionData.getIdCounts().getOrDefault(blockId, 0);
                            if (count < InfectionResistanceData.INFECTION_THRESHOLD) continue;
                            infectionData.addSmolderingBlockManually(serverLevel, checkPos, blockId);
                        }
                    }
                }
                if (!((level = this.beast.m_9236_()) instanceof ServerLevel)) continue;
                serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 5, 0.3, 0.3, 0.3, 0.0);
            }
            this.beast.setSoulValue(this.beast.getSoulValue() - 1);
        }
    }

    static class AbsorbExperienceGoal
    extends Goal {
        private final SoulDiveBeast beast;
        private int cooldown;

        public AbsorbExperienceGoal(SoulDiveBeast beast) {
            this.beast = beast;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            return this.beast.m_5448_() == null && this.beast.experienceTarget == null && this.beast.lastAttacker == null && !this.beast.isDiving() && this.beast.noActionTime > 100;
        }

        public void m_8037_() {
            AABB area = new AABB(this.beast.m_20183_()).m_82400_(8.0);
            List experienceOrbs = this.beast.m_9236_().m_45976_(ExperienceOrb.class, area);
            if (!experienceOrbs.isEmpty()) {
                ExperienceOrb orb = (ExperienceOrb)experienceOrbs.get(0);
                int experience = orb.m_20801_();
                this.beast.addSoulValue(experience);
                this.beast.m_9236_().m_5594_(null, this.beast.m_20183_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 1.0f, 1.0f);
                Level level = this.beast.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, orb.m_20185_(), orb.m_20186_() + (double)(orb.m_20206_() / 2.0f), orb.m_20189_(), experience, 0.5, 0.5, 0.5, 0.1);
                }
                orb.m_146870_();
            }
            this.cooldown = 2;
        }
    }

    static class CollectExperienceGoal
    extends Goal {
        private final SoulDiveBeast beast;
        private int cooldown;

        public CollectExperienceGoal(SoulDiveBeast beast) {
            this.beast = beast;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            return this.beast.experienceTarget != null && !this.beast.isDiving() && this.beast.diveCooldown <= 0 && this.beast.diveStateChangeCooldown <= 0;
        }

        public void m_8056_() {
            this.beast.shouldBeDiving = true;
            this.cooldown = 20;
        }

        public void m_8041_() {
            this.beast.shouldBeDiving = false;
            this.cooldown = 20;
        }
    }
}

