/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.blocks;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.cryofloric_arts.hao111111111.PlantSpreader;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.utils.DamageSourceUtil;
import org.cryofloric_arts.hao111111111.world.storage.InfectionResistanceData;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;
import org.jetbrains.annotations.NotNull;

public class SmolderingSoilBlock
extends Block {
    public SmolderingSoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_141947_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, Entity entity) {
        LivingEntity livingEntity;
        entity.m_20256_(entity.m_20184_().m_82542_(0.4, 1.0, 0.4));
        super.m_141947_(level, pos, state, entity);
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)ModEffects.FROZEN_EARTH_BLESSING.get())) {
            super.m_141947_(level, pos, state, entity);
            return;
        }
        DamageSource damageSource = DamageSourceUtil.getSoulCrushingDamage(level);
        entity.m_6469_(damageSource, 30.0f);
        super.m_141947_(level, pos, state, entity);
    }

    public void m_6807_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, level.m_213780_().m_216332_(2, 6));
        }
    }

    public void m_213897_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.f_46443_) {
            InfectionResistanceData data = InfectionResistanceData.get(level);
            CompoundTag blockData = data.getSmolderingBlocks().get(pos);
            if (blockData != null && blockData.m_128441_("target_id")) {
                String targetId = blockData.m_128461_("target_id");
                boolean foundTarget = false;
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -2; y <= 2; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            BlockPos checkPos;
                            BlockState checkState;
                            String currentBlockId;
                            if (x == 0 && y == 0 && z == 0 || !(currentBlockId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)(checkState = level.m_8055_(checkPos = pos.m_7918_(x, y, z))).m_60734_())).toString()).equals(targetId)) continue;
                            level.m_46597_(checkPos, this.m_49966_());
                            CompoundTag newData = new CompoundTag();
                            newData.m_128359_("target_id", targetId);
                            data.getSmolderingBlocks().put(checkPos, newData);
                            foundTarget = true;
                            level.m_186460_(checkPos, (Block)this, level.m_213780_().m_216332_(20, 60));
                        }
                    }
                }
                if (foundTarget) {
                    level.m_186460_(pos, (Block)this, level.m_213780_().m_216332_(20, 60));
                } else {
                    level.m_46597_(pos, ((Block)ModBlock.DEAD_ASH_SOIL.get()).m_49966_());
                    PollenData pollenData = PollenData.get(level);
                    pollenData.addPollen(level, new ChunkPos(pos), 1);
                    BlockPos targetPos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(3) - 1, random.m_188503_(3) - 1);
                    PlantSpreader.convertBlock(level, targetPos);
                    data.getSmolderingBlocks().remove(pos);
                    data.m_77762_();
                }
            } else {
                level.m_46597_(pos, ((Block)ModBlock.DEAD_ASH_SOIL.get()).m_49966_());
                PollenData pollenData = PollenData.get(level);
                pollenData.addPollen(level, new ChunkPos(pos), 1);
                BlockPos targetPos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(3) - 1, random.m_188503_(3) - 1);
                PlantSpreader.convertBlock(level, targetPos);
                data.getSmolderingBlocks().remove(pos);
                data.m_77762_();
            }
        }
    }
}

