/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.effect.debuff;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.utils.DamageSourceUtil;
import org.cryofloric_arts.hao111111111.world.storage.InfectionResistanceData;

public class SoulLeakage
extends MobEffect {
    private static final int PARTICLE_INTERVAL = 5;
    private static final int CHECK_INTERVAL = 200;
    private static final int SEARCH_RADIUS = 2;
    private final Map<LivingEntity, Integer> checkCounters = new WeakHashMap<LivingEntity, Integer>();

    public SoulLeakage() {
        super(MobEffectCategory.HARMFUL, 9055202);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Level level = entity.m_9236_();
        if (entity.m_21023_((MobEffect)ModEffects.FROZEN_EARTH_BLESSING.get())) {
            entity.m_21195_((MobEffect)this);
            return;
        }
        if (level.m_5776_()) {
            this.spawnSoulParticles(entity);
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int counter = this.checkCounters.getOrDefault(entity, 0) + 1;
            this.checkCounters.put(entity, counter);
            entity.m_6469_(DamageSourceUtil.getSoulCrushingDamage(level), (float)(amplifier + 1));
            if (counter >= 40) {
                BlockPos entityPos = entity.m_20183_();
                int convertedBlocks = this.convertNearbyBlocks(serverLevel, entityPos, amplifier);
                if (convertedBlocks > 0) {
                    float damage = convertedBlocks * 2 * (amplifier + 1);
                    entity.m_6469_(DamageSourceUtil.getSoulCrushingDamage(level), damage);
                }
                this.checkCounters.put(entity, 0);
            }
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 5 == 0;
    }

    private int convertNearbyBlocks(ServerLevel level, BlockPos centerPos, int amplifier) {
        int convertedCount = 0;
        InfectionResistanceData infectionData = InfectionResistanceData.get(level);
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    if (!level.m_46749_(checkPos) || !this.shouldConvertBlock(level, checkPos, infectionData)) continue;
                    String blockId = ForgeRegistries.BLOCKS.getKey((Object)level.m_8055_(checkPos).m_60734_()).toString();
                    level.m_46597_(checkPos, ((Block)ModBlock.SMOLDERING_SOIL.get()).m_49966_());
                    ++convertedCount;
                    infectionData.addSmolderingBlockManually(level, checkPos, blockId);
                }
            }
        }
        return convertedCount;
    }

    private boolean shouldConvertBlock(ServerLevel level, BlockPos pos, InfectionResistanceData infectionData) {
        return infectionData.shouldInfectBlock(level, pos);
    }

    private void spawnSoulParticles(LivingEntity entity) {
        Level level = entity.m_9236_();
        for (int i = 0; i < 3; ++i) {
            double x = entity.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_();
            double y = entity.m_20186_() + level.f_46441_.m_188500_() * (double)entity.m_20206_();
            double z = entity.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, y, z, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void handleSoulCrushingDamage(LivingEntity victim, DamageSource source, float amount) {
        boolean isSoulCrushingDamage;
        if (!victim.m_9236_().m_5776_() && (isSoulCrushingDamage = source.m_19385_().equals("soul_crushing"))) {
            if (victim.m_21023_((MobEffect)ModEffects.SOUL_LEAKAGE.get())) {
                if (amount >= 4.0f) {
                    MobEffectInstance currentEffect = victim.m_21124_((MobEffect)ModEffects.SOUL_LEAKAGE.get());
                    int newAmplifier = currentEffect.m_19564_();
                    if (amount >= (float)(newAmplifier * 20)) {
                        ++newAmplifier;
                    }
                    int newDuration = (int)((float)currentEffect.m_19557_() + (amount - 3.0f) * 100.0f);
                    victim.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SOUL_LEAKAGE.get(), newDuration, newAmplifier, currentEffect.m_19571_(), currentEffect.m_19572_(), currentEffect.m_19575_()));
                }
            } else if (amount >= 20.0f) {
                victim.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SOUL_LEAKAGE.get(), 100, 0, false, true, true));
            }
        }
    }
}

