/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.entity.custom;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.cryofloric_arts.hao111111111.PlantSpreader;
import org.cryofloric_arts.hao111111111.attributes.ModAttributes;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.entity.custom.SnowfallTaroCreature;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.cryofloric_arts.hao111111111.utils.DamageSourceUtil;
import org.jetbrains.annotations.NotNull;

public class DieCloudSubstance
extends SnowfallTaroCreature {
    private static final EntityDataAccessor<Integer> DATA_ABSORBED_COUNT = SynchedEntityData.m_135353_(DieCloudSubstance.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_BONE1_OFFSET_X = SynchedEntityData.m_135353_(DieCloudSubstance.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_BONE1_OFFSET_Y = SynchedEntityData.m_135353_(DieCloudSubstance.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_BONE1_OFFSET_Z = SynchedEntityData.m_135353_(DieCloudSubstance.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_BONE2_OFFSET_X = SynchedEntityData.m_135353_(DieCloudSubstance.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_BONE2_OFFSET_Y = SynchedEntityData.m_135353_(DieCloudSubstance.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_BONE2_OFFSET_Z = SynchedEntityData.m_135353_(DieCloudSubstance.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_BONE3_OFFSET_X = SynchedEntityData.m_135353_(DieCloudSubstance.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_BONE3_OFFSET_Y = SynchedEntityData.m_135353_(DieCloudSubstance.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_BONE3_OFFSET_Z = SynchedEntityData.m_135353_(DieCloudSubstance.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int healTimer = 0;
    private int effectTimer = 0;
    private int boneMoveTimer = 0;
    private int boneResetTimer = 0;
    private final Set<UUID> attackers = new HashSet<UUID>();

    public DieCloudSubstance(EntityType<? extends Animal> type, Level level) {
        super(type, level, 0, 9);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ModAttributes.MAX_DAMAGE_RATE.get(), 0.5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ABSORBED_COUNT, (Object)0);
        this.f_19804_.m_135372_(DATA_BONE1_OFFSET_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BONE1_OFFSET_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BONE1_OFFSET_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BONE2_OFFSET_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BONE2_OFFSET_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BONE2_OFFSET_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BONE3_OFFSET_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BONE3_OFFSET_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_BONE3_OFFSET_Z, (Object)Float.valueOf(0.0f));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AbsorbSoreCloudGoal());
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        if (target != null && !target.equals((Object)this)) {
            this.attackers.add(target.m_20148_());
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(@NotNull Entity entity) {
    }

    public void m_147240_(double strength, double x, double z) {
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.equals(this.m_269291_().m_269318_()) || source.equals(this.m_269291_().m_269063_()) || source.equals(this.m_269291_().m_269109_())) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            this.attackers.add(attacker.m_20148_());
        }
        return super.m_6469_(source, amount);
    }

    public void addAttacker(UUID attackerId) {
        this.attackers.add(attackerId);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            ++this.healTimer;
            if (this.healTimer >= 200) {
                float maxHealth = this.m_21233_();
                float healAmount = maxHealth * 0.01f;
                this.m_5634_(healAmount);
                this.healTimer = 0;
            }
            ++this.effectTimer;
            if (this.effectTimer >= 100) {
                this.applySoreRushToNearby();
                this.effectTimer = 0;
            }
            ++this.boneMoveTimer;
            if (this.boneMoveTimer >= 20) {
                this.moveBonesRandomly();
                this.boneMoveTimer = 0;
                this.boneResetTimer = 20;
            }
            this.cleanupDeadAttackers();
        }
    }

    private void cleanupDeadAttackers() {
        if (!this.attackers.isEmpty()) {
            HashSet<UUID> toRemove = new HashSet<UUID>();
            for (UUID attackerId : this.attackers) {
                Entity attacker = ((ServerLevel)this.m_9236_()).m_8791_(attackerId);
                if (attacker != null && attacker.m_6084_()) continue;
                toRemove.add(attackerId);
            }
            this.attackers.removeAll(toRemove);
        }
    }

    public void m_6667_(@NotNull DamageSource source) {
        super.m_6667_(source);
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        BlockPos pos = this.m_20183_();
        ServerLevel level = (ServerLevel)this.m_9236_();
        int absorbedCount = this.getAbsorbedCount();
        int baseRange = 2;
        int extraRange = Math.min(absorbedCount / 50, 7);
        int totalRange = baseRange + extraRange;
        float baseChance = 0.8f;
        float extraChance = Math.min((float)absorbedCount * 0.01f, 0.15f);
        float totalChance = Math.min(baseChance + extraChance, 0.95f);
        BlockPos minPos = pos.m_7918_(-totalRange, -totalRange, -totalRange);
        BlockPos maxPos = pos.m_7918_(totalRange, totalRange, totalRange);
        BlockPos.m_121990_((BlockPos)minPos, (BlockPos)maxPos).forEach(p -> {
            if (this.f_19796_.m_188501_() < totalChance) {
                PlantSpreader.convertToCloudSubstance(level, p);
            }
        });
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 20, 1.0, 1.0, 1.0, 0.2);
    }

    public void setAbsorbedCount(int count) {
        this.f_19804_.m_135381_(DATA_ABSORBED_COUNT, (Object)count);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(this.countGetHEALTH(Double.valueOf(count)).doubleValue());
        this.m_21153_(this.m_21233_());
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() == ModEffects.OVER_ROOTING.get() || effect.m_19544_() == ModEffects.FROST_POWDER.get() || effect.m_19544_() == ModEffects.LIFE_MULTIPLIER.get() || effect.m_19544_() == ModEffects.SOUL_STRIKE.get() || effect.m_19544_() == ModEffects.FROZEN_EARTH_BLESSING.get();
    }

    public Double countGetHEALTH(Double getAbsorbedCount) {
        return 30.0 + getAbsorbedCount / (getAbsorbedCount + 250.0) * 720.0;
    }

    private void applySoreRushToNearby() {
        AABB area = new AABB(this.m_20183_()).m_82400_(16.0 + (double)this.getAbsorbedCount() / ((double)this.getAbsorbedCount() + 250.0) * 80.0);
        List entities = this.m_9236_().m_45976_(LivingEntity.class, area);
        for (LivingEntity entity : entities) {
            Level level;
            if (entity == this || entity.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) continue;
            MobEffectInstance currentEffect = entity.m_21124_((MobEffect)ModEffects.SORE_RUSH.get());
            if (currentEffect != null) {
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SORE_RUSH.get(), currentEffect.m_19557_() + 1200, currentEffect.m_19564_(), false, false, true));
            } else {
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SORE_RUSH.get(), 600, 0, false, false, true));
            }
            entity.getPersistentData().m_128362_("SoreRushSource", this.m_20148_());
            if (this.attackers.contains(entity.m_20148_())) {
                Level level2;
                float damage = (float)(5.0 + (double)this.getAbsorbedCount() / (double)((float)this.getAbsorbedCount() + 300.0f) * 75.0 * this.m_21172_(Attributes.f_22281_));
                boolean wasHurt = entity.m_6469_(DamageSourceUtil.getFreezeDamage(this.m_9236_(), (LivingEntity)this), damage);
                if (wasHurt && !entity.m_6084_()) {
                    this.attackers.remove(entity.m_20148_());
                }
                if ((level2 = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123754_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 8, 0.3, 0.3, 0.3, 0.1);
                }
            }
            if (!((level = this.m_9236_()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 5, 0.5, 0.5, 0.5, 0.0);
        }
    }

    private void moveBonesRandomly() {
        this.f_19804_.m_135381_(DATA_BONE1_OFFSET_X, (Object)Float.valueOf((this.f_19796_.m_188501_() - 0.5f) * 8.0f));
        this.f_19804_.m_135381_(DATA_BONE1_OFFSET_Y, (Object)Float.valueOf((this.f_19796_.m_188501_() - 0.5f) * 8.0f));
        this.f_19804_.m_135381_(DATA_BONE1_OFFSET_Z, (Object)Float.valueOf((this.f_19796_.m_188501_() - 0.5f) * 8.0f));
        this.f_19804_.m_135381_(DATA_BONE2_OFFSET_X, (Object)Float.valueOf((this.f_19796_.m_188501_() - 0.5f) * 8.0f));
        this.f_19804_.m_135381_(DATA_BONE2_OFFSET_Y, (Object)Float.valueOf((this.f_19796_.m_188501_() - 0.5f) * 8.0f));
        this.f_19804_.m_135381_(DATA_BONE2_OFFSET_Z, (Object)Float.valueOf((this.f_19796_.m_188501_() - 0.5f) * 8.0f));
        this.f_19804_.m_135381_(DATA_BONE3_OFFSET_X, (Object)Float.valueOf((this.f_19796_.m_188501_() - 0.5f) * 8.0f));
        this.f_19804_.m_135381_(DATA_BONE3_OFFSET_Y, (Object)Float.valueOf((this.f_19796_.m_188501_() - 0.5f) * 8.0f));
        this.f_19804_.m_135381_(DATA_BONE3_OFFSET_Z, (Object)Float.valueOf((this.f_19796_.m_188501_() - 0.5f) * 8.0f));
    }

    private void resetBones() {
        this.f_19804_.m_135381_(DATA_BONE1_OFFSET_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135381_(DATA_BONE1_OFFSET_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135381_(DATA_BONE1_OFFSET_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135381_(DATA_BONE2_OFFSET_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135381_(DATA_BONE2_OFFSET_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135381_(DATA_BONE2_OFFSET_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135381_(DATA_BONE3_OFFSET_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135381_(DATA_BONE3_OFFSET_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135381_(DATA_BONE3_OFFSET_Z, (Object)Float.valueOf(0.0f));
    }

    public float getBone1OffsetX() {
        return ((Float)this.f_19804_.m_135370_(DATA_BONE1_OFFSET_X)).floatValue();
    }

    public float getBone1OffsetY() {
        return ((Float)this.f_19804_.m_135370_(DATA_BONE1_OFFSET_Y)).floatValue();
    }

    public float getBone1OffsetZ() {
        return ((Float)this.f_19804_.m_135370_(DATA_BONE1_OFFSET_Z)).floatValue();
    }

    public float getBone2OffsetX() {
        return ((Float)this.f_19804_.m_135370_(DATA_BONE2_OFFSET_X)).floatValue();
    }

    public float getBone2OffsetY() {
        return ((Float)this.f_19804_.m_135370_(DATA_BONE2_OFFSET_Y)).floatValue();
    }

    public float getBone2OffsetZ() {
        return ((Float)this.f_19804_.m_135370_(DATA_BONE2_OFFSET_Z)).floatValue();
    }

    public float getBone3OffsetX() {
        return ((Float)this.f_19804_.m_135370_(DATA_BONE3_OFFSET_X)).floatValue();
    }

    public float getBone3OffsetY() {
        return ((Float)this.f_19804_.m_135370_(DATA_BONE3_OFFSET_Y)).floatValue();
    }

    public float getBone3OffsetZ() {
        return ((Float)this.f_19804_.m_135370_(DATA_BONE3_OFFSET_Z)).floatValue();
    }

    public int getAbsorbedCount() {
        return (Integer)this.f_19804_.m_135370_(DATA_ABSORBED_COUNT);
    }

    private void absorbSoreCloud(int count) {
        int currentCount = this.getAbsorbedCount();
        this.f_19804_.m_135381_(DATA_ABSORBED_COUNT, (Object)(currentCount + count));
        currentCount = this.getAbsorbedCount();
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(this.countGetHEALTH(Double.valueOf(currentCount)).doubleValue());
        this.m_21153_(this.m_21233_());
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("AbsorbedSoreClouds", this.getAbsorbedCount());
        ListTag attackersList = new ListTag();
        for (UUID attackerId : this.attackers) {
            CompoundTag attackerTag = new CompoundTag();
            attackerTag.m_128362_("Attacker", attackerId);
            attackersList.add((Object)attackerTag);
        }
        compound.m_128365_("Attackers", (Tag)attackersList);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("AbsorbedSoreClouds")) {
            int count = compound.m_128451_("AbsorbedSoreClouds");
            this.f_19804_.m_135381_(DATA_ABSORBED_COUNT, (Object)count);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(this.countGetHEALTH(Double.valueOf(count)).doubleValue());
        }
        if (compound.m_128441_("Attackers")) {
            this.attackers.clear();
            ListTag attackersList = compound.m_128437_("Attackers", 10);
            for (int i = 0; i < attackersList.size(); ++i) {
                CompoundTag attackerTag = attackersList.m_128728_(i);
                if (!attackerTag.m_128403_("Attacker")) continue;
                this.attackers.add(attackerTag.m_128342_("Attacker"));
            }
        }
    }

    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        return null;
    }

    class AbsorbSoreCloudGoal
    extends Goal {
        public AbsorbSoreCloudGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            int count = 0;
            AABB area = new AABB(DieCloudSubstance.this.m_20183_()).m_82400_(16.0 + (double)count / ((double)count + 250.0) * 96.0);
            List items = DieCloudSubstance.this.m_9236_().m_45976_(ItemEntity.class, area);
            for (ItemEntity item : items) {
                if (item.m_32055_().m_41720_() != ModItem.SORE_CLOUD_SUBSTANCE.get()) continue;
                count = item.m_32055_().m_41613_();
                DieCloudSubstance.this.absorbSoreCloud(count);
                item.m_146870_();
            }
        }
    }
}

