/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.events;

import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.cryofloric_arts.hao111111111.Cryofloric_arts;
import org.cryofloric_arts.hao111111111.config.ModConfig;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.cryofloric_arts.hao111111111.loot.functions.RandomNbtFunction;

@Mod.EventBusSubscriber(modid="cryofloric_arts")
public class PatternedMobSpawnHandler {
    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getEntity() instanceof Mob) {
            Mob mob = event.getEntity();
            if (PatternedMobSpawnHandler.isEntityInBlacklist(mob)) {
                return;
            }
            if (mob.m_21051_(Attributes.f_22281_) != null && mob.m_21133_(Attributes.f_22281_) > 0.0) {
                Double spawnChance = (Double)ModConfig.PATTERNED_MOB_SPAWN_CHANCE.get();
                float regionalDifficulty = event.getLevel().m_6436_(mob.m_20183_()).m_19056_();
                if ((double)event.getLevel().m_213780_().m_188503_(100) < spawnChance && (float)event.getLevel().m_213780_().m_188503_(10) < regionalDifficulty) {
                    PatternedMobSpawnHandler.equipPatternedArmor(mob, regionalDifficulty);
                    PatternedMobSpawnHandler.applyFrostPowderEffect(mob);
                }
            }
        }
    }

    private static boolean isEntityInBlacklist(Mob mob) {
        List blacklist = (List)ModConfig.PATTERNED_MOB_BLACKLIST.get();
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (entityId == null) {
            return false;
        }
        String entityNamespace = entityId.m_135827_();
        for (String entry : blacklist) {
            if (entry.startsWith("#")) {
                String tagName = entry.substring(1);
                try {
                    ResourceLocation tagLocation = new ResourceLocation(tagName);
                    TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)tagLocation);
                    if (!mob.m_6095_().m_204039_(tagKey)) continue;
                    return true;
                }
                catch (Exception e) {
                    Cryofloric_arts.LOGGER.warn("\u6807\u7b7e\u683c\u5f0f\u65e0\u6548: {}", (Object)tagName);
                    continue;
                }
            }
            if (!(entry.contains(":") ? entry.equals(entityId.toString()) : entry.equals(entityNamespace))) continue;
            return true;
        }
        return false;
    }

    private static void equipPatternedArmor(Mob mob, float regionalDifficulty) {
        float baseChance = 0.3f;
        float chanceIncrease = 0.15f;
        float maxChance = 0.9f;
        float equipChance = baseChance + regionalDifficulty * chanceIncrease;
        equipChance = Math.min(equipChance, maxChance);
        if (mob.m_6844_(EquipmentSlot.HEAD).m_41619_() && mob.m_217043_().m_188501_() < equipChance) {
            ItemStack helmet = new ItemStack((ItemLike)ModItem.PATTERNED_HELMET.get());
            RandomNbtFunction.addPatternedArmorTags(helmet, mob);
            mob.m_8061_(EquipmentSlot.HEAD, helmet);
        }
        if (mob.m_6844_(EquipmentSlot.CHEST).m_41619_() && mob.m_217043_().m_188501_() < equipChance) {
            ItemStack chestplate = new ItemStack((ItemLike)ModItem.PATTERNED_CHESTPLATE.get());
            RandomNbtFunction.addPatternedArmorTags(chestplate, mob);
            mob.m_8061_(EquipmentSlot.CHEST, chestplate);
        }
        if (mob.m_6844_(EquipmentSlot.LEGS).m_41619_() && mob.m_217043_().m_188501_() < equipChance) {
            ItemStack leggings = new ItemStack((ItemLike)ModItem.PATTERNED_LEGGINGS.get());
            RandomNbtFunction.addPatternedArmorTags(leggings, mob);
            mob.m_8061_(EquipmentSlot.LEGS, leggings);
        }
        if (mob.m_6844_(EquipmentSlot.FEET).m_41619_() && mob.m_217043_().m_188501_() < equipChance) {
            ItemStack boots = new ItemStack((ItemLike)ModItem.PATTERNED_BOOTS.get());
            RandomNbtFunction.addPatternedArmorTags(boots, mob);
            mob.m_8061_(EquipmentSlot.FEET, boots);
        }
        PatternedMobSpawnHandler.equipAndTagWeapon(mob, EquipmentSlot.MAINHAND, equipChance);
        PatternedMobSpawnHandler.equipAndTagWeapon(mob, EquipmentSlot.OFFHAND, equipChance);
    }

    private static void equipAndTagWeapon(Mob mob, EquipmentSlot slot, float equipChance) {
        ItemStack currentWeapon = mob.m_6844_(slot);
        if (currentWeapon.m_41619_() && mob.m_217043_().m_188501_() < equipChance * 0.5f) {
            ItemStack weapon = new ItemStack((ItemLike)ModItem.PATTERNED_SWORD.get());
            RandomNbtFunction.addPatternedArmorTags(weapon, mob);
            mob.m_8061_(slot, weapon);
        } else if (!currentWeapon.m_41619_() && RandomNbtFunction.hasOwnerTags(currentWeapon)) {
            RandomNbtFunction.addPatternedArmorTags(currentWeapon, mob);
        }
    }

    private static void applyFrostPowderEffect(Mob mob) {
        int duration = 18000;
        MobEffectInstance frostPowderEffect = new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), duration, 0, false, true, true);
        mob.m_7292_(frostPowderEffect);
    }
}

