/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.item.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.cryofloric_arts.hao111111111.attributes.ModAttributes;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.cryofloric_arts.hao111111111.item.item.InspectionReportItem;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;
import org.jetbrains.annotations.NotNull;

public class SamplingNeedleItem
extends Item {
    public SamplingNeedleItem(Item.Properties properties) {
        super(properties);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (player.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!this.hasSamplingData(stack)) {
            CompoundTag samplingData = this.collectEntityData(target);
            CompoundTag tag = stack.m_41784_();
            tag.m_128365_("SamplingData", (Tag)samplingData);
            stack.m_41751_(tag);
            player.m_5661_((Component)Component.m_237115_((String)"item.cryofloric_arts.sampling_needle.sampling_success"), true);
            player.m_21008_(hand, stack);
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() != ModItem.VANISHING_PAPER.get()) {
            player.m_5661_((Component)Component.m_237115_((String)"item.cryofloric_arts.sampling_needle.already_has_data"), true);
            return InteractionResult.FAIL;
        }
        if (SamplingNeedleItem.getSamplingData(player.m_21120_(InteractionHand.MAIN_HAND)).m_128456_()) {
            CompoundTag samplingData = this.collectEntityData((LivingEntity)player);
            CompoundTag tag = stack.m_41784_();
            tag.m_128365_("SamplingData", (Tag)samplingData);
            stack.m_41751_(tag);
            player.m_5661_((Component)Component.m_237115_((String)"item.cryofloric_arts.sampling_needle.sampling_success"), true);
            player.m_21008_(hand, stack);
        }
        if (player.m_9236_().f_46443_) return InteractionResult.SUCCESS;
        ItemStack reportStack = new ItemStack((ItemLike)ModItem.INSPECTION_REPORT.get());
        InspectionReportItem.setReportData(reportStack, SamplingNeedleItem.getSamplingData(player.m_21120_(InteractionHand.MAIN_HAND)));
        ItemStack newNeedle = player.m_21120_(InteractionHand.MAIN_HAND).m_41777_();
        SamplingNeedleItem.clearSamplingData(newNeedle);
        player.m_21120_(InteractionHand.OFF_HAND).m_41774_(1);
        player.m_21008_(InteractionHand.MAIN_HAND, newNeedle);
        if (!player.m_150109_().m_36054_(reportStack)) {
            player.m_36176_(reportStack, false);
        }
        player.m_5661_((Component)Component.m_237115_((String)"item.cryofloric_arts.inspection_report.created"), true);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!SamplingNeedleItem.getSamplingData(player.m_21120_(InteractionHand.MAIN_HAND)).m_128456_()) {
            if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() == ModItem.VANISHING_PAPER.get()) {
                ItemStack reportStack = new ItemStack((ItemLike)ModItem.INSPECTION_REPORT.get());
                InspectionReportItem.setReportData(reportStack, SamplingNeedleItem.getSamplingData(player.m_21120_(InteractionHand.MAIN_HAND)));
                ItemStack newNeedle = player.m_21120_(InteractionHand.MAIN_HAND).m_41777_();
                SamplingNeedleItem.clearSamplingData(newNeedle);
                player.m_21120_(InteractionHand.OFF_HAND).m_41774_(1);
                player.m_21008_(InteractionHand.MAIN_HAND, newNeedle);
                if (!player.m_150109_().m_36054_(reportStack)) {
                    player.m_36176_(reportStack, false);
                }
                player.m_5661_((Component)Component.m_237115_((String)"item.cryofloric_arts.inspection_report.created"), true);
            }
        } else {
            CompoundTag samplingData = this.collectEntityData((LivingEntity)player);
            CompoundTag tag = player.m_21120_(hand).m_41784_();
            tag.m_128365_("SamplingData", (Tag)samplingData);
            player.m_21120_(hand).m_41751_(tag);
            player.m_5661_((Component)Component.m_237115_((String)"item.cryofloric_arts.sampling_needle.sampling_success"), true);
            player.m_21008_(hand, player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    private boolean hasSamplingData(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41782_() && stack.m_41783_().m_128441_("SamplingData");
        }
        return false;
    }

    private CompoundTag collectEntityData(LivingEntity entity) {
        CompoundTag data = new CompoundTag();
        if (entity.m_8077_()) {
            data.m_128359_("CustomName", Objects.requireNonNull(entity.m_7770_()).getString());
        }
        String entityType = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_())).toString();
        data.m_128359_("EntityType", entityType);
        data.m_128359_("EntityName", Component.m_237115_((String)("entity." + entityType.replace(":", "."))).getString());
        CompoundTag attributes = new CompoundTag();
        this.saveAttribute(attributes, "MaxHealth", entity.m_21051_(Attributes.f_22276_));
        this.saveAttribute(attributes, "AttackDamage", entity.m_21051_(Attributes.f_22281_));
        this.saveAttribute(attributes, "Armor", entity.m_21051_(Attributes.f_22284_));
        this.saveAttribute(attributes, "ArmorToughness", entity.m_21051_(Attributes.f_22285_));
        AttributeInstance maxDamageRateAttr = entity.m_21051_((Attribute)ModAttributes.MAX_DAMAGE_RATE.get());
        if (maxDamageRateAttr != null) {
            attributes.m_128347_("MaxDamageRate", maxDamageRateAttr.m_22135_());
        } else {
            attributes.m_128347_("MaxDamageRate", 1.0);
        }
        data.m_128365_("Attributes", (Tag)attributes);
        ListTag effects = new ListTag();
        for (MobEffectInstance effect : entity.m_21220_()) {
            CompoundTag effectTag = new CompoundTag();
            effectTag.m_128359_("Effect", Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect.m_19544_())).toString());
            effectTag.m_128405_("Duration", effect.m_19557_());
            effectTag.m_128405_("Amplifier", effect.m_19564_());
            effects.add((Object)effectTag);
        }
        data.m_128365_("Effects", (Tag)effects);
        int extraPollen = PollenData.getExtraPollenValue(entity);
        data.m_128405_("ExtraPollen", extraPollen);
        CompoundTag hyperplasiaData = SamplingNeedleItem.getCompoundTag(entity);
        data.m_128365_("Hyperplasia", (Tag)hyperplasiaData);
        data.m_128356_("SamplingTime", System.currentTimeMillis());
        return data;
    }

    @NotNull
    private static CompoundTag getCompoundTag(LivingEntity entity) {
        CompoundTag hyperplasiaData = new CompoundTag();
        CompoundTag persistentData = entity.getPersistentData();
        if (persistentData.m_128441_("HyperplasiaUnlocked")) {
            hyperplasiaData.m_128379_("Unlocked", persistentData.m_128471_("HyperplasiaUnlocked"));
            hyperplasiaData.m_128405_("Value", persistentData.m_128451_("HyperplasiaValue"));
            if (persistentData.m_128441_("HyperplasiaType")) {
                hyperplasiaData.m_128359_("Type", persistentData.m_128461_("HyperplasiaType"));
            }
        } else {
            hyperplasiaData.m_128379_("Unlocked", false);
            hyperplasiaData.m_128405_("Value", 0);
        }
        return hyperplasiaData;
    }

    private void saveAttribute(CompoundTag tag, String key, AttributeInstance attribute) {
        if (attribute != null) {
            tag.m_128347_(key, attribute.m_22135_());
        } else {
            tag.m_128347_(key, 0.0);
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (this.hasSamplingData(stack)) {
            CompoundTag samplingData = null;
            if (stack.m_41783_() != null) {
                samplingData = stack.m_41783_().m_128469_("SamplingData");
            }
            tooltip.add((Component)Component.m_237115_((String)"item.cryofloric_arts.sampling_needle.tooltip.has_data"));
            if (samplingData != null && samplingData.m_128441_("CustomName")) {
                tooltip.add((Component)Component.m_237110_((String)"item.cryofloric_arts.sampling_needle.tooltip.name", (Object[])new Object[]{samplingData.m_128461_("CustomName")}));
            }
            String entityName = null;
            if (samplingData != null) {
                entityName = samplingData.m_128461_("EntityName");
            }
            tooltip.add((Component)Component.m_237110_((String)"item.cryofloric_arts.sampling_needle.tooltip.type", (Object[])new Object[]{entityName}));
            CompoundTag attributes = null;
            if (samplingData != null) {
                attributes = samplingData.m_128469_("Attributes");
            }
            double health = 0.0;
            if (attributes != null) {
                health = attributes.m_128459_("MaxHealth");
            }
            tooltip.add((Component)Component.m_237110_((String)"item.cryofloric_arts.sampling_needle.tooltip.health", (Object[])new Object[]{String.format("%.1f", health)}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.cryofloric_arts.sampling_needle.tooltip.empty"));
        }
    }

    public static CompoundTag getSamplingData(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41720_() instanceof SamplingNeedleItem && stack.m_41782_() && stack.m_41783_().m_128441_("SamplingData")) {
            return stack.m_41783_().m_128469_("SamplingData");
        }
        return new CompoundTag();
    }

    public static void clearSamplingData(ItemStack stack) {
        if (stack.m_41782_()) {
            if (stack.m_41783_() != null) {
                stack.m_41783_().m_128473_("SamplingData");
            }
            if (stack.m_41783_() != null && stack.m_41783_().m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }

    public boolean m_41468_() {
        return true;
    }
}

