/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.world.storage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.registries.ForgeRegistries;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.config.ModConfig;
import org.jetbrains.annotations.NotNull;

public class InfectionResistanceData
extends SavedData {
    private static final TagKey<Block> CAN_NOT_BEPOWDER = BlockTags.create((ResourceLocation)new ResourceLocation("cryofloric_arts", "can_not_bepowder"));
    private final Map<BlockPos, Long> scheduledChecks = new ConcurrentHashMap<BlockPos, Long>();
    private final Map<String, Integer> idCounts = new HashMap<String, Integer>();
    private final Map<BlockPos, CompoundTag> smolderingBlocks = new HashMap<BlockPos, CompoundTag>();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private volatile boolean isTimerRunning = false;
    public static final int INFECTION_THRESHOLD = (Integer)ModConfig.INFECTION_RESISTANCE_TRIGGER_THRESHOLD.get();

    public static InfectionResistanceData get(ServerLevel level) {
        DimensionDataStorage storage = level.m_8895_();
        InfectionResistanceData data = (InfectionResistanceData)storage.m_164861_(InfectionResistanceData::load, InfectionResistanceData::new, "cryofloric_infection_data");
        data.startTimer(level);
        return data;
    }

    public void scheduleBlockCheck(ServerLevel level, BlockPos pos, BlockState originalState) {
        long checkTime = System.currentTimeMillis() + 10000L;
        this.scheduledChecks.put(pos, checkTime);
        this.startTimer(level);
        this.m_77762_();
    }

    private synchronized void startTimer(ServerLevel level) {
        if (!this.isTimerRunning && !this.scheduledChecks.isEmpty()) {
            this.isTimerRunning = true;
            this.scheduler.scheduleAtFixedRate(() -> this.processScheduledChecks(level), 2L, 2L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processScheduledChecks(ServerLevel level) {
        if (this.scheduledChecks.isEmpty()) {
            InfectionResistanceData infectionResistanceData = this;
            synchronized (infectionResistanceData) {
                if (this.scheduledChecks.isEmpty()) {
                    this.isTimerRunning = false;
                    return;
                }
            }
        }
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<BlockPos, Long>> iterator = this.scheduledChecks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, Long> entry = iterator.next();
            BlockPos pos = entry.getKey();
            long checkTime = entry.getValue();
            if (currentTime < checkTime) continue;
            level.m_7654_().execute(() -> this.checkBlock(level, pos));
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(ServerLevel level) {
        if (this.scheduledChecks.isEmpty() && this.isTimerRunning) {
            InfectionResistanceData infectionResistanceData = this;
            synchronized (infectionResistanceData) {
                if (this.scheduledChecks.isEmpty()) {
                    this.isTimerRunning = false;
                }
            }
        }
    }

    private void checkBlock(ServerLevel level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return;
        }
        BlockState currentState = level.m_8055_(pos);
        String currentId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)currentState.m_60734_())).toString();
        if (currentState.m_204336_(CAN_NOT_BEPOWDER)) {
            return;
        }
        int count = this.idCounts.getOrDefault(currentId, 0) + 1;
        this.idCounts.put(currentId, count);
        this.m_77762_();
        if (count >= INFECTION_THRESHOLD) {
            level.m_46597_(pos, ((Block)ModBlock.SMOLDERING_SOIL.get()).m_49966_());
            CompoundTag smolderingData = new CompoundTag();
            smolderingData.m_128359_("target_id", currentId);
            this.smolderingBlocks.put(pos, smolderingData);
            this.m_77762_();
        } else {
            level.m_46597_(pos, ((Block)ModBlock.DEAD_ASH_SOIL.get()).m_49966_());
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag nbt) {
        ListTag scheduledList = new ListTag();
        for (Map.Entry<BlockPos, Long> entry : this.scheduledChecks.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("x", entry.getKey().m_123341_());
            compoundTag.m_128405_("y", entry.getKey().m_123342_());
            compoundTag.m_128405_("z", entry.getKey().m_123343_());
            compoundTag.m_128356_("checkTime", entry.getValue().longValue());
            scheduledList.add((Object)compoundTag);
        }
        nbt.m_128365_("ScheduledChecks", (Tag)scheduledList);
        CompoundTag countsTag = new CompoundTag();
        for (Map.Entry<String, Integer> entry : this.idCounts.entrySet()) {
            countsTag.m_128405_(entry.getKey(), entry.getValue().intValue());
        }
        nbt.m_128365_("IdCounts", (Tag)countsTag);
        ListTag listTag = new ListTag();
        for (Map.Entry<BlockPos, CompoundTag> entry : this.smolderingBlocks.entrySet()) {
            CompoundTag entryTag = entry.getValue().m_6426_();
            entryTag.m_128405_("x", entry.getKey().m_123341_());
            entryTag.m_128405_("y", entry.getKey().m_123342_());
            entryTag.m_128405_("z", entry.getKey().m_123343_());
            listTag.add((Object)entryTag);
        }
        nbt.m_128365_("SmolderingBlocks", (Tag)listTag);
        return nbt;
    }

    public Map<BlockPos, Long> getScheduledChecks() {
        return this.scheduledChecks;
    }

    public Map<String, Integer> getIdCounts() {
        return this.idCounts;
    }

    public Map<BlockPos, CompoundTag> getSmolderingBlocks() {
        return this.smolderingBlocks;
    }

    public static InfectionResistanceData load(CompoundTag nbt) {
        BlockPos pos;
        CompoundTag entryTag;
        InfectionResistanceData data = new InfectionResistanceData();
        if (nbt.m_128425_("ScheduledChecks", 9)) {
            ListTag scheduledList = nbt.m_128437_("ScheduledChecks", 10);
            for (Tag tag : scheduledList) {
                entryTag = (CompoundTag)tag;
                pos = new BlockPos(entryTag.m_128451_("x"), entryTag.m_128451_("y"), entryTag.m_128451_("z"));
                long checkTime = entryTag.m_128454_("checkTime");
                data.scheduledChecks.put(pos, checkTime);
            }
        }
        if (nbt.m_128425_("IdCounts", 10)) {
            CompoundTag countsTag = nbt.m_128469_("IdCounts");
            for (String key : countsTag.m_128431_()) {
                data.idCounts.put(key, countsTag.m_128451_(key));
            }
        }
        if (nbt.m_128425_("SmolderingBlocks", 9)) {
            ListTag smolderingList = nbt.m_128437_("SmolderingBlocks", 10);
            for (Tag tag : smolderingList) {
                entryTag = (CompoundTag)tag;
                pos = new BlockPos(entryTag.m_128451_("x"), entryTag.m_128451_("y"), entryTag.m_128451_("z"));
                CompoundTag blockData = entryTag.m_6426_();
                blockData.m_128473_("x");
                blockData.m_128473_("y");
                blockData.m_128473_("z");
                data.smolderingBlocks.put(pos, blockData);
            }
        }
        return data;
    }

    public boolean shouldInfectBlock(ServerLevel level, BlockPos pos) {
        BlockState currentState = level.m_8055_(pos);
        String currentId = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)currentState.m_60734_())).toString();
        if (currentState.m_204336_(CAN_NOT_BEPOWDER)) {
            return false;
        }
        int count = this.idCounts.getOrDefault(currentId, 0);
        return count >= INFECTION_THRESHOLD;
    }

    public void cleanup() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void addSmolderingBlockManually(ServerLevel level, BlockPos pos, String targetId) {
        if (!level.m_46749_(pos)) {
            return;
        }
        level.m_46597_(pos, ((Block)ModBlock.SMOLDERING_SOIL.get()).m_49966_());
        CompoundTag smolderingData = new CompoundTag();
        smolderingData.m_128359_("target_id", targetId);
        this.smolderingBlocks.put(pos, smolderingData);
        this.m_77762_();
    }
}

