/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.cryofloric_arts.hao111111111.effect.ModEffects;

public class AquaticFrigidGrass
extends FlowerBlock
implements LiquidBlockContainer,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final float HORIZONTAL_SPEED_MULTIPLIER = 0.9f;
    private static final float VERTICAL_SPEED_MULTIPLIER = 1.5f;
    private static final float HORIZONTAL_PARTICLE_MOMENTUM_FACTOR = 0.083333336f;
    private static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);
    private static final VoxelShape COLLISION_SHAPE = Shapes.m_83144_();

    public AquaticFrigidGrass(BlockBehaviour.Properties properties) {
        super(ModEffects.FROSTED, 32, properties.m_60977_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false && this.isSupported(level, pos);
    }

    private boolean isSupported(LevelReader level, BlockPos pos) {
        return AquaticFrigidGrass.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP) || level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        FluidState fluidState = level.m_6425_(pos);
        if (fluidState.m_76152_() != Fluids.f_76193_) {
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && !level.m_5776_()) {
            level.m_46961_(currentPos, true);
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
        super.m_7926_(builder);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!(fallDistance < 4.0f) && entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            LivingEntity.Fallsounds fallsounds = livingentity.m_196493_();
            SoundEvent soundevent = fallDistance < 7.0f ? fallsounds.f_196626_() : fallsounds.f_196627_();
            entity.m_5496_(soundevent, 1.0f, 1.0f);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity livingentity;
        entity.m_7601_(state, new Vec3((double)0.9f, 1.5, (double)0.9f));
        entity.m_146924_(true);
        if (entity instanceof LivingEntity && !(livingentity = (LivingEntity)entity).m_6673_(level.m_269111_().m_269109_())) {
            livingentity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 20, 0, false, false, true));
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollision;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityCollision = (EntityCollisionContext)context).m_193113_()) != null) {
            if (entity.f_19789_ > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            boolean fallingBlock = entity instanceof FallingBlockEntity;
            if (fallingBlock || AquaticFrigidGrass.canWalkOnPowderSnow(entity) && context.m_6513_(COLLISION_SHAPE, pos, false) && !context.m_6226_()) {
                return super.m_5939_(state, level, pos, context);
            }
        }
        return Shapes.m_83040_();
    }

    private static boolean canWalkOnPowderSnow(Entity entity) {
        boolean bl;
        if (entity.m_6095_().m_204039_(EntityTypeTags.f_144291_)) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            bl = livingEntity.m_6844_(EquipmentSlot.FEET).canWalkOnPowderedSnow(livingEntity);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false && fluid == Fluids.f_76193_;
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (fluidState.m_76152_() == Fluids.f_76193_ && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
            }
            level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return true;
    }
}

