/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.events;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.utils.DamageSourceUtil;

@Mod.EventBusSubscriber(modid="cryofloric_arts")
public class ItemOwnershipHandler {
    private static final ResourceLocation SOUL_CRUSHING_DAMAGE = DamageSourceUtil.SOUL_CRUSHING_DAMAGE;

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemOwnershipHandler.checkAndDropOwnedItem(player, player.m_21205_(), InteractionHand.MAIN_HAND);
            ItemOwnershipHandler.checkAndDropOwnedItem(player, player.m_21206_(), InteractionHand.OFF_HAND);
            for (ItemStack armorStack : player.m_150109_().f_35975_) {
                ItemOwnershipHandler.checkAndDropOwnedItemFromInventory(player, armorStack);
            }
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                ItemOwnershipHandler.checkAndDropOwnedItemFromInventory(player, stack);
            }
        }
    }

    private static void checkAndDropOwnedItem(Player player, ItemStack stack, InteractionHand hand) {
        CompoundTag tag;
        if (!stack.m_41619_() && stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("OwnerUUID") && !tag.m_128342_("OwnerUUID").equals(player.m_20148_())) {
            int soulCrushingLevel = tag.m_128441_("SoulCrushingBone") ? tag.m_128451_("SoulCrushingBone") : 0;
            int frostAttachmentLevel = tag.m_128441_("FrostAttachment") ? tag.m_128451_("FrostAttachment") : 0;
            int cloudSoreRushmentLevel = tag.m_128441_("CloudSoreRush") ? tag.m_128451_("CloudSoreRush") : 0;
            player.m_36176_(stack, false);
            player.m_21008_(hand, ItemStack.f_41583_);
            if (!player.m_9236_().f_46443_) {
                ItemOwnershipHandler.applyEffects(player, soulCrushingLevel, frostAttachmentLevel, cloudSoreRushmentLevel);
            }
        }
    }

    private static void checkAndDropOwnedItemFromInventory(Player player, ItemStack stack) {
        CompoundTag tag;
        if (!stack.m_41619_() && stack.m_41782_() && (tag = stack.m_41783_()) != null && tag.m_128441_("OwnerUUID") && !tag.m_128342_("OwnerUUID").equals(player.m_20148_())) {
            int soulCrushingLevel = tag.m_128441_("SoulCrushingBone") ? tag.m_128451_("SoulCrushingBone") : 0;
            int frostAttachmentLevel = tag.m_128441_("FrostAttachment") ? tag.m_128451_("FrostAttachment") : 0;
            int cloudSoreRushmentLevel = tag.m_128441_("CloudSoreRush") ? tag.m_128451_("CloudSoreRush") : 0;
            ItemOwnershipHandler.removeItemFromInventory(player, stack);
            player.m_36176_(stack, false);
            if (!player.m_9236_().f_46443_) {
                ItemOwnershipHandler.applyEffects(player, soulCrushingLevel, frostAttachmentLevel, cloudSoreRushmentLevel);
            }
        }
    }

    private static void removeItemFromInventory(Player player, ItemStack stackToRemove) {
        ItemStack stack;
        int i;
        for (i = 0; i < player.m_150109_().m_6643_(); ++i) {
            stack = player.m_150109_().m_8020_(i);
            if (stack != stackToRemove) continue;
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            return;
        }
        for (i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            stack = (ItemStack)player.m_150109_().f_35975_.get(i);
            if (stack != stackToRemove) continue;
            player.m_150109_().f_35975_.set(i, (Object)ItemStack.f_41583_);
            return;
        }
    }

    private static void applyEffects(Player player, int soulCrushingLevel, int frostAttachmentLevel, int cloudSoreRushmentLevel) {
        if (cloudSoreRushmentLevel > 0) {
            int effectLevel = (int)Math.round((double)(1 + cloudSoreRushmentLevel) / (30.0 + (double)cloudSoreRushmentLevel) * 3.0 + 1.0);
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SORE_RUSH.get(), 2000, effectLevel));
        }
        if (soulCrushingLevel > 0) {
            DamageSource soulCrushingDamage;
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                soulCrushingDamage = new DamageSource((Holder)serverLevel.m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)SOUL_CRUSHING_DAMAGE)));
            } else {
                soulCrushingDamage = player.m_269291_().m_269264_();
            }
            player.m_6469_(soulCrushingDamage, (float)(soulCrushingLevel * 4));
        }
        if (frostAttachmentLevel > 0) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROSTED.get(), 200, frostAttachmentLevel - 1));
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 200, 0));
        }
    }
}

