/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.cryofloric_arts.hao111111111.blockentity.TransmutationFurnaceBlockEntity;
import org.cryofloric_arts.hao111111111.inventory.ModMenuTypes;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.jetbrains.annotations.NotNull;

public class TransmutationFurnaceMenu
extends AbstractContainerMenu {
    private final TransmutationFurnaceBlockEntity blockEntity;
    private final ContainerData data;
    private final IItemHandler playerInventory;
    private final ItemStackHandler dummyHandler;

    private void addCustomSlots() {
        ItemStackHandler handler = this.blockEntity != null ? this.blockEntity.getItemHandler() : this.dummyHandler;
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 56, 17));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1, 56, 53){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return stack.m_41720_() == ModItem.FROST_DUST.get();
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 2, 116, 35){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }
        });
    }

    public TransmutationFurnaceMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, null, (ContainerData)new SimpleContainerData(4));
    }

    public TransmutationFurnaceMenu(int containerId, Inventory playerInventory, TransmutationFurnaceBlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.TRANSMUTATION_FURNACE_MENU.get(), containerId);
        this.blockEntity = blockEntity;
        this.data = data;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.dummyHandler = new ItemStackHandler(3){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> true;
                    case 1 -> {
                        if (stack.m_41720_() == ModItem.FROST_DUST.get()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }
        };
        this.addCustomSlots();
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        if (data != null) {
            this.m_38884_(data);
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            itemstack = stackInSlot.m_41777_();
            if (index == 2) {
                if (!this.m_38903_(stackInSlot, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stackInSlot, itemstack);
            } else if (index != 1 && index != 0 ? (stackInSlot.m_41720_() == ModItem.FROST_DUST.get() ? !this.m_38903_(stackInSlot, 1, 2, false) : !this.m_38903_(stackInSlot, 0, 1, false)) : !this.m_38903_(stackInSlot, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public int getLitProgress() {
        int litDuration = this.data.m_6413_(1);
        if (litDuration == 0) {
            return 0;
        }
        return this.data.m_6413_(0) * 13 / litDuration;
    }

    public int getCookProgress() {
        int cookingTotalTime = this.data.m_6413_(3);
        if (cookingTotalTime == 0) {
            return 0;
        }
        return this.data.m_6413_(2) * 24 / cookingTotalTime;
    }

    public boolean isLit() {
        return this.data.m_6413_(0) > 0;
    }

    public IItemHandler getPlayerInventory() {
        return this.playerInventory;
    }
}

