/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.item.item;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;
import org.jetbrains.annotations.NotNull;

public class FrostDustDetector
extends Item {
    private static final String DETECTION_BOOST_TAG = "DetectionBoost";

    public FrostDustDetector(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkPos playerChunk = new ChunkPos(player.m_20183_());
            PollenData data = PollenData.get(serverLevel);
            int pollenValue = data.getPollenValue(playerChunk);
            ItemStack newStack = stack.m_41777_();
            CompoundTag tag = newStack.m_41784_();
            tag.m_128405_("PollenValue", pollenValue);
            return InteractionResultHolder.m_19090_((Object)newStack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static void registerProperties() {
        ItemProperties.register((Item)((Item)ModItem.FROST_DUST_DETECTOR.get()), (ResourceLocation)new ResourceLocation("cryofloric_arts", "pollen_value"), (stack, level, entity, seed) -> {
            if (stack.m_41782_()) {
                CompoundTag tag = stack.m_41783_();
                int value = 0;
                if (tag != null) {
                    value = tag.m_128451_("PollenValue");
                }
                int boostLevel = FrostDustDetector.getBoostLevel(stack);
                return (float)Math.min((double)value / Math.pow(100.0, boostLevel + 1), 1.0);
            }
            return 0.0f;
        });
    }

    static int getBoostLevel(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41782_() && stack.m_41783_().m_128441_(DETECTION_BOOST_TAG)) {
            return stack.m_41783_().m_128451_(DETECTION_BOOST_TAG);
        }
        return 0;
    }
}

