/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.entity.custom;

import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.entity.ModEntityTypes;
import org.cryofloric_arts.hao111111111.utils.RootsAttachmentHelper;

public class RootsEntity
extends Entity {
    private LivingEntity hostEntity;
    private UUID hostUUID;
    private int age = 0;
    private int attachmentPointIndex;
    private double clientX;
    private double clientY;
    private double clientZ;
    private double clientPrevX;
    private double clientPrevY;
    private double clientPrevZ;

    public RootsEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public RootsEntity(Level level, LivingEntity host, int attachmentPointIndex) {
        super((EntityType)ModEntityTypes.ROOTS.get(), level);
        this.hostEntity = host;
        this.hostUUID = host.m_20148_();
        this.attachmentPointIndex = attachmentPointIndex;
        this.m_6034_(host.m_20185_(), host.m_20186_(), host.m_20189_());
        this.clientX = this.m_20185_();
        this.clientY = this.m_20186_();
        this.clientZ = this.m_20189_();
        this.clientPrevX = this.clientX;
        this.clientPrevY = this.clientY;
        this.clientPrevZ = this.clientZ;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_8119_() {
        super.m_8119_();
        ++this.age;
        this.clientPrevX = this.clientX;
        this.clientPrevY = this.clientY;
        this.clientPrevZ = this.clientZ;
        if (!this.m_9236_().f_46443_) {
            if (this.age < 5) {
                return;
            }
            if (this.hostEntity == null || this.hostEntity.m_213877_()) {
                if (this.hostUUID == null) {
                    this.m_146870_();
                    return;
                }
                Entity entity2 = ((ServerLevel)this.m_9236_()).m_8791_(this.hostUUID);
                if (!(entity2 instanceof LivingEntity)) {
                    this.m_146870_();
                    return;
                }
                this.hostEntity = (LivingEntity)entity2;
            }
            if (this.hostEntity.m_6084_() && this.hostEntity.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
                double[] targetPos = this.calculateAttachmentPosition();
                double targetX = targetPos[0];
                double targetY = targetPos[1];
                double targetZ = targetPos[2];
                double lerpFactor = 0.2;
                double newX = this.m_20185_() + (targetX - this.m_20185_()) * lerpFactor;
                double newY = this.m_20186_() + (targetY - this.m_20186_()) * lerpFactor;
                double newZ = this.m_20189_() + (targetZ - this.m_20189_()) * lerpFactor;
                this.m_6034_(newX, newY, newZ);
                this.m_146922_(this.hostEntity.m_146908_());
                this.m_146926_(this.hostEntity.m_146909_());
                this.clientX = this.m_20185_();
                this.clientY = this.m_20186_();
                this.clientZ = this.m_20189_();
                return;
            }
            this.m_146870_();
            return;
        }
        if (this.hostEntity == null && this.hostUUID != null) {
            List allEntities = this.m_9236_().m_6249_((Entity)null, this.m_20191_().m_82400_(50.0), entity -> true);
            for (Entity entity3 : allEntities) {
                if (!entity3.m_20148_().equals(this.hostUUID) || !(entity3 instanceof LivingEntity)) continue;
                this.hostEntity = (LivingEntity)entity3;
                break;
            }
        }
        if (this.hostEntity == null) return;
        double[] targetPos = this.calculateAttachmentPosition();
        double targetX = targetPos[0];
        double targetY = targetPos[1];
        double targetZ = targetPos[2];
        double lerpFactor = 0.2;
        this.clientX += (targetX - this.clientX) * lerpFactor;
        this.clientY += (targetY - this.clientY) * lerpFactor;
        this.clientZ += (targetZ - this.clientZ) * lerpFactor;
        this.m_6034_(this.clientX, this.clientY, this.clientZ);
        this.m_146922_(this.hostEntity.m_146908_());
        this.m_146926_(this.hostEntity.m_146909_());
    }

    private double[] calculateAttachmentPosition() {
        if (this.hostEntity == null) {
            return new double[]{this.m_20185_(), this.m_20186_(), this.m_20189_()};
        }
        float[] points = RootsAttachmentHelper.getAttachmentPoints(this.hostEntity.m_20148_());
        if (points == null || points.length < 6) {
            return new double[]{this.hostEntity.m_20185_(), this.hostEntity.m_20186_(), this.hostEntity.m_20189_()};
        }
        int baseIndex = this.attachmentPointIndex * 3;
        float localX = points[baseIndex];
        float localY = points[baseIndex + 1];
        float localZ = points[baseIndex + 2];
        float yaw = this.hostEntity.f_19859_ + (this.hostEntity.m_146908_() - this.hostEntity.f_19859_) * 0.5f;
        double rad = Math.toRadians(yaw);
        double worldX = (double)localX * Math.cos(rad) - (double)localZ * Math.sin(rad);
        double worldZ = (double)localX * Math.sin(rad) + (double)localZ * Math.cos(rad);
        return new double[]{this.hostEntity.m_20185_() + worldX, this.hostEntity.m_20186_() + (double)localY, this.hostEntity.m_20189_() + worldZ};
    }

    public double m_20165_(double partialTicks) {
        return this.clientPrevX + (this.clientX - this.clientPrevX) * partialTicks;
    }

    public double m_20227_(double partialTicks) {
        return this.clientPrevY + (this.clientY - this.clientPrevY) * partialTicks;
    }

    public double m_20246_(double partialTicks) {
        return this.clientPrevZ + (this.clientZ - this.clientPrevZ) * partialTicks;
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("HostUUID")) {
            this.hostUUID = compound.m_128342_("HostUUID");
        }
        if (compound.m_128441_("Age")) {
            this.age = compound.m_128451_("Age");
        }
        if (compound.m_128441_("AttachmentPoint")) {
            this.attachmentPointIndex = compound.m_128451_("AttachmentPoint");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.hostUUID != null) {
            compound.m_128362_("HostUUID", this.hostUUID);
        }
        compound.m_128405_("Age", this.age);
        compound.m_128405_("AttachmentPoint", this.attachmentPointIndex);
    }

    protected void m_8097_() {
    }

    public LivingEntity getHost() {
        return this.hostEntity;
    }

    public float getScale() {
        if (this.hostEntity != null) {
            float hostSize = (this.hostEntity.m_20205_() + this.hostEntity.m_20206_()) / 2.0f;
            return hostSize * 0.5f;
        }
        return 1.0f;
    }

    public int getAttachmentPointIndex() {
        return this.attachmentPointIndex;
    }
}

