/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.cryofloric_arts.hao111111111.effect.ModEffects;

@Mod.EventBusSubscriber(modid="cryofloric_arts")
public class ContainerEvents {
    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open event) {
        AbstractContainerMenu menu = event.getContainer();
        if (menu instanceof ChestMenu) {
            ChestMenu chestMenu = (ChestMenu)menu;
            Level level = event.getEntity().m_9236_();
            BlockPos pos = null;
            Container container = chestMenu.m_39261_();
            if (container instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity container2 = (RandomizableContainerBlockEntity)container;
                pos = container2.m_58899_();
                if (container2.getPersistentData().m_128471_("BlindfrostBeastMarked")) {
                    AreaEffectCloud cloud = new AreaEffectCloud(EntityType.f_20476_, level);
                    cloud.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5);
                    cloud.m_19712_(3.0f);
                    cloud.m_19724_((ParticleOptions)ParticleTypes.f_175821_);
                    cloud.m_19734_(600);
                    cloud.m_19716_(new MobEffectInstance((MobEffect)ModEffects.FROSTED.get(), 600, 3));
                    cloud.m_19716_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 1200, 0));
                    level.m_7967_((Entity)cloud);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 30; ++i) {
                            double x = (double)pos.m_123341_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 3.0;
                            double y = (double)pos.m_123342_() + 1.0 + (double)serverLevel.f_46441_.m_188501_() * 2.0;
                            double z = (double)pos.m_123343_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 3.0;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onContainerBroken(BlockEvent.BreakEvent event) {
        RandomizableContainerBlockEntity container;
        BlockPos pos;
        Level level = (Level)event.getLevel();
        BlockEntity blockEntity = level.m_7702_(pos = event.getPos());
        if (blockEntity instanceof RandomizableContainerBlockEntity && (container = (RandomizableContainerBlockEntity)blockEntity).getPersistentData().m_128471_("BlindfrostBeastMarked")) {
            AreaEffectCloud cloud = new AreaEffectCloud(EntityType.f_20476_, level);
            cloud.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5);
            cloud.m_19712_(6.0f);
            cloud.m_19724_((ParticleOptions)ParticleTypes.f_175821_);
            cloud.m_19734_(800);
            cloud.m_19716_(new MobEffectInstance((MobEffect)ModEffects.FROSTED.get(), 800, 3));
            cloud.m_19716_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 3600, 0));
            level.m_7967_((Entity)cloud);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 50; ++i) {
                    double x = (double)pos.m_123341_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 5.0;
                    double y = (double)pos.m_123342_() + 1.0 + (double)serverLevel.f_46441_.m_188501_() * 3.0;
                    double z = (double)pos.m_123343_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 5.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                serverLevel.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 0.8f + serverLevel.f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        for (BlockPos pos : event.getAffectedBlocks()) {
            RandomizableContainerBlockEntity container;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof RandomizableContainerBlockEntity) || !(container = (RandomizableContainerBlockEntity)blockEntity).getPersistentData().m_128471_("BlindfrostBeastMarked")) continue;
            AreaEffectCloud cloud = new AreaEffectCloud(EntityType.f_20476_, level);
            cloud.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5);
            cloud.m_19712_(6.0f);
            cloud.m_19724_((ParticleOptions)ParticleTypes.f_175821_);
            cloud.m_19734_(800);
            cloud.m_19716_(new MobEffectInstance((MobEffect)ModEffects.FROSTED.get(), 800, 3));
            cloud.m_19716_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 3600, 0));
            level.m_7967_((Entity)cloud);
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 50; ++i) {
                double x = (double)pos.m_123341_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 5.0;
                double y = (double)pos.m_123342_() + 1.0 + (double)serverLevel.f_46441_.m_188501_() * 3.0;
                double z = (double)pos.m_123343_() + 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * 5.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

