/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.blockentity;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.cryofloric_arts.hao111111111.blockentity.ModBlockEntities;
import org.cryofloric_arts.hao111111111.blocks.TransmutationFurnaceBlock;
import org.cryofloric_arts.hao111111111.inventory.TransmutationFurnaceMenu;
import org.cryofloric_arts.hao111111111.item.ModItem;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransmutationFurnaceBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            TransmutationFurnaceBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> true;
                case 1 -> {
                    if (stack.m_41720_() == ModItem.FROST_DUST.get()) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final ContainerData data = new SimpleContainerData(4);
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private final Random random = new Random();

    public TransmutationFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRANSMUTATION_FURNACE.get(), pos, state);
        this.data.m_8050_(0, 0);
        this.data.m_8050_(1, 0);
        this.data.m_8050_(2, 0);
        this.data.m_8050_(3, 0);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.cryofloric_arts.transmutation_furnace");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new TransmutationFurnaceMenu(containerId, playerInventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("litTime", this.litTime);
        tag.m_128405_("litDuration", this.litDuration);
        tag.m_128405_("cookingProgress", this.cookingProgress);
        tag.m_128405_("cookingTotalTime", this.cookingTotalTime);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.litTime = tag.m_128451_("litTime");
        this.litDuration = tag.m_128451_("litDuration");
        this.cookingProgress = tag.m_128451_("cookingProgress");
        this.cookingTotalTime = tag.m_128451_("cookingTotalTime");
        this.updateBlockState();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TransmutationFurnaceBlockEntity blockEntity) {
        boolean wasLit = blockEntity.litTime > 0;
        boolean changed = false;
        if (blockEntity.litTime > 0) {
            --blockEntity.litTime;
        }
        ItemStack input = blockEntity.itemHandler.getStackInSlot(0);
        ItemStack fuel = blockEntity.itemHandler.getStackInSlot(1);
        ItemStack output = blockEntity.itemHandler.getStackInSlot(2);
        if (blockEntity.litTime <= 0 && !input.m_41619_() && blockEntity.canSmelt(input) && !fuel.m_41619_() && fuel.m_41720_() == ModItem.FROST_DUST.get()) {
            blockEntity.litDuration = blockEntity.litTime = 200;
            fuel.m_41774_(1);
            changed = true;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                blockEntity.addPollenValue(serverLevel);
            }
        }
        if (blockEntity.litTime > 0 && blockEntity.canSmelt(input)) {
            ++blockEntity.cookingProgress;
            if (blockEntity.cookingProgress >= blockEntity.cookingTotalTime) {
                blockEntity.smeltItem();
                blockEntity.cookingProgress = 0;
                changed = true;
            }
        } else {
            blockEntity.cookingProgress = 0;
        }
        if (wasLit != blockEntity.litTime > 0) {
            changed = true;
            state = (BlockState)state.m_61124_((Property)TransmutationFurnaceBlock.LIT, (Comparable)Boolean.valueOf(blockEntity.litTime > 0));
            level.m_7731_(pos, state, 3);
        }
        if (changed) {
            blockEntity.m_6596_();
        }
        blockEntity.data.m_8050_(0, blockEntity.litTime);
        blockEntity.data.m_8050_(1, blockEntity.litDuration);
        blockEntity.data.m_8050_(2, blockEntity.cookingProgress);
        blockEntity.data.m_8050_(3, blockEntity.cookingTotalTime);
    }

    private boolean canSmelt(ItemStack input) {
        if (input.m_41619_()) {
            return false;
        }
        Optional<SmeltingRecipe> furnaceRecipe = this.getFurnaceRecipe(input);
        Optional<SmokingRecipe> smokingRecipe = this.getSmokingRecipe(input);
        Optional<BlastingRecipe> blastingRecipe = this.getBlastingRecipe(input);
        if (furnaceRecipe.isPresent()) {
            this.cookingTotalTime = furnaceRecipe.get().m_43753_();
            return true;
        }
        if (smokingRecipe.isPresent()) {
            this.cookingTotalTime = smokingRecipe.get().m_43753_();
            return true;
        }
        if (blastingRecipe.isPresent()) {
            this.cookingTotalTime = blastingRecipe.get().m_43753_();
            return true;
        }
        return false;
    }

    private Optional<SmeltingRecipe> getFurnaceRecipe(ItemStack input) {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        SimpleContainer container = new SimpleContainer(new ItemStack[]{input});
        return this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)container, this.f_58857_);
    }

    private Optional<SmokingRecipe> getSmokingRecipe(ItemStack input) {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        SimpleContainer container = new SimpleContainer(new ItemStack[]{input});
        return this.f_58857_.m_7465_().m_44015_(RecipeType.f_44110_, (Container)container, this.f_58857_);
    }

    private Optional<BlastingRecipe> getBlastingRecipe(ItemStack input) {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        SimpleContainer container = new SimpleContainer(new ItemStack[]{input});
        return this.f_58857_.m_7465_().m_44015_(RecipeType.f_44109_, (Container)container, this.f_58857_);
    }

    private void smeltItem() {
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack output = this.itemHandler.getStackInSlot(2);
        Optional<SmeltingRecipe> furnaceRecipe = this.getFurnaceRecipe(input);
        Optional<SmokingRecipe> smokingRecipe = this.getSmokingRecipe(input);
        Optional<BlastingRecipe> blastingRecipe = this.getBlastingRecipe(input);
        ItemStack result = ItemStack.f_41583_;
        if (furnaceRecipe.isPresent()) {
            result = furnaceRecipe.get().m_8043_(this.f_58857_.m_9598_()).m_41777_();
        } else if (smokingRecipe.isPresent()) {
            result = smokingRecipe.get().m_8043_(this.f_58857_.m_9598_()).m_41777_();
        } else if (blastingRecipe.isPresent()) {
            result = blastingRecipe.get().m_8043_(this.f_58857_.m_9598_()).m_41777_();
        }
        if (!result.m_41619_()) {
            if (output.m_41619_()) {
                this.itemHandler.setStackInSlot(2, result);
            } else if (output.m_150930_(result.m_41720_()) && ItemStack.m_150942_((ItemStack)output, (ItemStack)result)) {
                output.m_41769_(result.m_41613_());
            }
            input.m_41774_(1);
        }
    }

    private void addPollenValue(ServerLevel serverLevel) {
        PollenData pollenData = PollenData.get(serverLevel);
        ChunkPos chunkPos = new ChunkPos(this.f_58858_);
        pollenData.addPollen(serverLevel, chunkPos, 1);
        if (this.random.nextInt(5) == 0) {
            pollenData.addPollen(serverLevel, chunkPos, 1);
        }
    }

    private void updateBlockState() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean shouldBeLit;
            BlockState state = this.m_58900_();
            boolean isLit = (Boolean)state.m_61143_((Property)TransmutationFurnaceBlock.LIT);
            boolean bl = shouldBeLit = this.litTime > 0;
            if (isLit != shouldBeLit) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)TransmutationFurnaceBlock.LIT, (Comparable)Boolean.valueOf(shouldBeLit)), 3);
            }
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public void dropAllItems(Level level, BlockPos pos) {
        int i;
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }
}

