/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.cryofloric_arts.hao111111111.PlantSpreader;
import org.cryofloric_arts.hao111111111.config.ModConfig;
import org.cryofloric_arts.hao111111111.world.biome.ModBiomes;
import org.cryofloric_arts.hao111111111.world.storage.InfectionResistanceData;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;
import org.jetbrains.annotations.NotNull;

public class BlightSorrowLog
extends RotatedPillarBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    private static final float HORIZONTAL_SPEED_MULTIPLIER = 0.9f;
    private static final float VERTICAL_SPEED_MULTIPLIER = 1.5f;
    private static final VoxelShape FALLING_COLLISION_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);
    private static final VoxelShape COLLISION_SHAPE = Shapes.m_83144_();

    public BlightSorrowLog(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.Y));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_43719_().m_122434_());
    }

    public void m_213898_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        ChunkPos chunkPos;
        PollenData pollenData = PollenData.get(level);
        int pollenValue = pollenData.getPollenValue(chunkPos = new ChunkPos(pos));
        if (pollenValue > (Integer)ModConfig.INFECTION_RESISTANCE_START_THRESHOLD.get() && random.m_188501_() < 0.1f) {
            InfectionResistanceData resistanceData = InfectionResistanceData.get(level);
            resistanceData.scheduleBlockCheck(level, pos, state);
        }
        if (level.m_204166_(pos).m_203565_(ModBiomes.WHITE_BARRENS) && (double)random.m_188501_() < 0.001) {
            BlockPos.m_121990_((BlockPos)pos.m_7918_(-3, -3, -3), (BlockPos)pos.m_7918_(3, 3, 3)).forEach(p -> {
                if (p.equals((Object)pos)) {
                    return;
                }
                PlantSpreader.convertBlock(level, p);
            });
        }
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext entityCollision;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityCollision = (EntityCollisionContext)context).m_193113_()) != null) {
            if (entity.f_19789_ > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            boolean fallingBlock = entity instanceof FallingBlockEntity;
            if (fallingBlock || BlightSorrowLog.canWalkOnPowderSnow(entity) && context.m_6513_(COLLISION_SHAPE, pos, false) && !context.m_6226_()) {
                return super.m_5939_(state, level, pos, context);
            }
        }
        return Shapes.m_83040_();
    }

    private static boolean canWalkOnPowderSnow(Entity entity) {
        LivingEntity livingEntity;
        if (entity.m_6095_().m_204039_(EntityTypeTags.f_144291_)) {
            return true;
        }
        return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6844_(EquipmentSlot.FEET).canWalkOnPowderedSnow(livingEntity);
    }

    public void m_7892_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, Entity entity) {
        LivingEntity livingEntity;
        entity.m_7601_(state, new Vec3((double)0.9f, 1.5, (double)0.9f));
        if (!level.f_46443_ && entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_6673_(level.m_269111_().m_269109_())) {
            int currentFreezeTicks = livingEntity.m_146888_();
            livingEntity.m_146917_(currentFreezeTicks + 1);
        }
        super.m_7892_(state, level, pos, entity);
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return true;
    }

    public void m_142072_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, float fallDistance) {
        if (!(fallDistance < 4.0f) && entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            LivingEntity.Fallsounds fallsounds = livingentity.m_196493_();
            SoundEvent soundevent = fallDistance < 7.0f ? fallsounds.f_196626_() : fallsounds.f_196627_();
            entity.m_5496_(soundevent, 1.0f, 1.0f);
        }
    }
}

