/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.blocks;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.cryofloric_arts.hao111111111.PlantSpreader;
import org.cryofloric_arts.hao111111111.config.ModConfig;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.world.biome.ModBiomes;
import org.cryofloric_arts.hao111111111.world.storage.InfectionResistanceData;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;
import org.jetbrains.annotations.NotNull;

public class CloudSubstanceBlock
extends Block {
    public CloudSubstanceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!level.f_46443_ && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
                return;
            }
            Random random = new Random();
            if (random.nextFloat() < 0.1f) {
                if (livingEntity.m_21023_((MobEffect)ModEffects.SORE_RUSH.get())) {
                    MobEffectInstance currentEffect = livingEntity.m_21124_((MobEffect)ModEffects.SORE_RUSH.get());
                    int newDuration = currentEffect.m_19557_() + 200;
                    int amplifier = currentEffect.m_19564_();
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SORE_RUSH.get(), newDuration, amplifier, false, false, true));
                } else {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SORE_RUSH.get(), 300, 0, false, false, true));
                }
            }
        }
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!level.f_46443_) {
            this.convertNearbyBlocks((ServerLevel)level, pos);
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.f_46443_ && !newState.m_60713_((Block)this)) {
            this.convertNearbyBlocks((ServerLevel)level, pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private void convertNearbyBlocks(ServerLevel level, BlockPos centerPos) {
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Random random;
                    BlockPos targetPos = centerPos.m_7918_(x, y, z);
                    if (targetPos.equals((Object)centerPos) || !((random = new Random()).nextFloat() < 0.1f)) continue;
                    PlantSpreader.convertBlock(level, targetPos);
                }
            }
        }
    }

    public void m_213898_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        ChunkPos chunkPos;
        PollenData pollenData = PollenData.get(level);
        int pollenValue = pollenData.getPollenValue(chunkPos = new ChunkPos(pos));
        if (pollenValue > (Integer)ModConfig.INFECTION_RESISTANCE_START_THRESHOLD.get() && random.m_188501_() < 0.01f) {
            InfectionResistanceData resistanceData = InfectionResistanceData.get(level);
            resistanceData.scheduleBlockCheck(level, pos, state);
        }
        if (level.m_204166_(pos).m_203565_(ModBiomes.WHITE_BARRENS) && (double)random.m_188501_() < 0.001) {
            BlockPos.m_121990_((BlockPos)pos.m_7918_(-3, -3, -3), (BlockPos)pos.m_7918_(3, 3, 3)).forEach(p -> {
                if (p.equals((Object)pos)) {
                    return;
                }
                PlantSpreader.convertBlock(level, p);
            });
        }
    }
}

