/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.cryofloric_arts.hao111111111.blockentity.DustAbsorberBlockEntity;
import org.jetbrains.annotations.Nullable;

public class DustAbsorberBlock
extends BaseEntityBlock {
    public static final BooleanProperty DAMAGED = BooleanProperty.m_61465_((String)"damaged");
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public DustAbsorberBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DAMAGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DAMAGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof DustAbsorberBlockEntity) {
                DustAbsorberBlockEntity dustAbsorber = (DustAbsorberBlockEntity)blockEntity;
                dustAbsorber.dropAllDust(level, pos);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)DAMAGED)).booleanValue()) {
            player.m_5661_((Component)Component.m_237115_((String)"block.cryofloric_arts.dust_absorber.damaged"), true);
            return InteractionResult.FAIL;
        }
        if (this.hasBlocksAround(level, pos)) {
            player.m_5661_((Component)Component.m_237115_((String)"block.cryofloric_arts.dust_absorber.obstructed"), true);
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DustAbsorberBlockEntity) {
            DustAbsorberBlockEntity dustAbsorber = (DustAbsorberBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)dustAbsorber, (BlockPos)pos);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private boolean hasBlocksAround(Level level, BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y <= 3; ++y) {
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    if (checkPos.equals((Object)pos) || level.m_46859_(checkPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DustAbsorberBlockEntity) {
            DustAbsorberBlockEntity dustAbsorber = (DustAbsorberBlockEntity)blockEntity;
            return dustAbsorber.getRedstoneSignal();
        }
        return 0;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.hasBlocksAround((Level)level, pos)) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DustAbsorberBlockEntity) {
            DustAbsorberBlockEntity dustAbsorber = (DustAbsorberBlockEntity)blockEntity;
            dustAbsorber.absorbPollen();
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DustAbsorberBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return null;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return false;
    }
}

