/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.cryofloric_arts.hao111111111.PlantSpreader;
import org.cryofloric_arts.hao111111111.blocks.AquaticFrigidGrass;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;

public class TransformationSacBlock
extends GlassBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final TagKey<Block> CAN_PLANT = BlockTags.create((ResourceLocation)new ResourceLocation("cryofloric_arts", "can_plant"));

    public TransformationSacBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos targetPos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(3) - 1, random.m_188503_(3) - 1);
        BlockState targetState = level.m_8055_(targetPos);
        if (!targetState.m_60795_() && !targetState.m_60819_().m_76178_()) {
            PlantSpreader.convertBlock(level, targetPos);
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            this.convertNearbySacsToAquaticGrass(level, pos, random);
        } else {
            BlockPos belowPos = pos.m_7495_();
            BlockState belowState = level.m_8055_(belowPos);
            if (belowState.m_204336_(PlantSpreader.DIRT) || belowState.m_204336_(CAN_PLANT)) {
                Block targetBlock;
                Block block = targetBlock = random.m_188499_() ? (Block)ModBlock.SORE_GRASS.get() : (Block)ModBlock.ICE_PETAL_DRYAD_BLOOM.get();
                if (targetBlock.m_49966_().m_60710_((LevelReader)level, pos)) {
                    level.m_7731_(pos, targetBlock.m_49966_(), 3);
                    this.convertNearbySacsToPlants(level, pos, targetBlock, random);
                }
            }
        }
    }

    private void convertNearbySacsToAquaticGrass(ServerLevel level, BlockPos centerPos, RandomSource random) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockState aquaticGrassState;
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    BlockState checkState = level.m_8055_(checkPos);
                    if (!(checkState.m_60734_() instanceof TransformationSacBlock) || !(aquaticGrassState = (BlockState)((Block)ModBlock.AQUATIC_FRIGID_GRASS.get()).m_49966_().m_61124_((Property)AquaticFrigidGrass.WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_60710_((LevelReader)level, checkPos)) continue;
                    level.m_7731_(checkPos, aquaticGrassState, 3);
                }
            }
        }
    }

    private void convertNearbySacsToPlants(ServerLevel level, BlockPos centerPos, Block targetBlock, RandomSource random) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos belowPos;
                    BlockState belowState;
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    BlockState checkState = level.m_8055_(checkPos);
                    if (!(checkState.m_60734_() instanceof TransformationSacBlock) || !(belowState = level.m_8055_(belowPos = checkPos.m_7495_())).m_204336_(PlantSpreader.DIRT) && !belowState.m_204336_(CAN_PLANT) || !targetBlock.m_49966_().m_60710_((LevelReader)level, checkPos)) continue;
                    level.m_7731_(checkPos, targetBlock.m_49966_(), 3);
                }
            }
        }
    }
}

