/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.effect.buff;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.cryofloric_arts.hao111111111.blockentity.BloatedSnowfallTaroTuberBlockEntity;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.config.ModConfig;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.entity.custom.RootsEntity;
import org.cryofloric_arts.hao111111111.particle.ModParticles;
import org.cryofloric_arts.hao111111111.utils.HyperplasiaSystem;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;
import org.jetbrains.annotations.NotNull;

public class OverRooting
extends MobEffect {
    public OverRooting() {
        super(MobEffectCategory.NEUTRAL, 45539);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        ServerLevel serverLevel;
        PollenData pollenData;
        int pollenValue;
        if (entity.m_21223_() < entity.m_21233_()) {
            entity.m_5634_(5.0f * (float)(amplifier + 1));
        }
        entity.getPersistentData().m_128379_("PersistenceRequired", true);
        MobEffectInstance frostPowderEffect = entity.m_21124_((MobEffect)ModEffects.FROST_POWDER.get());
        if (frostPowderEffect != null) {
            int durationToAdd = 300 + amplifier * 20;
            int newDuration = frostPowderEffect.m_19557_() + durationToAdd;
            int newAmplifier = frostPowderEffect.m_19564_();
            entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), newDuration, newAmplifier, true, true, true));
        } else {
            entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 2500, 0, true, true, true));
        }
        OverRooting.repairEntityEquipment(entity, amplifier);
        OverRooting.spawnRootsEntities(entity, amplifier);
        Level newDuration = entity.m_9236_();
        if (newDuration instanceof ServerLevel && (pollenValue = (pollenData = PollenData.get(serverLevel = (ServerLevel)newDuration)).getPollenValueAtWithExtra(entity.m_20183_(), entity)) > 100) {
            OverRooting.spawnFloatingRootsParticlesAroundEntity(entity.m_9236_(), entity, amplifier);
            List nearbyEntities = serverLevel.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(3.0), e -> e != entity);
            for (LivingEntity target : nearbyEntities) {
                if (target.m_21124_((MobEffect)ModEffects.FROST_POWDER.get()) != null) continue;
                target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 3000, 0, false, false, true));
            }
        }
    }

    private static void spawnFloatingRootsParticlesAroundEntity(Level level, LivingEntity entity, int amplifier) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int particleCount = 5 + amplifier * 2;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (level.f_46441_.m_188500_() - 0.5) * 2.0;
                double offsetY = level.f_46441_.m_188500_() * 2.0;
                double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 2.0;
                double x = entity.m_20185_() + offsetX;
                double y = entity.m_20186_() + offsetY;
                double z = entity.m_20189_() + offsetZ;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.FLOATING_ROOTS_PARTICLE.get()), x, y, z, 1, 0.0, 0.0, 0.0, 0.01 + level.f_46441_.m_188500_() * 0.02);
            }
        }
    }

    public static void spawnRootsEntities(LivingEntity entity, int amplifier) {
        Level level;
        if (!entity.m_9236_().f_46443_ && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int count = 3;
            List existingRoots = serverLevel.m_6443_(RootsEntity.class, entity.m_20191_().m_82400_(10.0), roots -> roots.getHost() != null && roots.getHost().equals((Object)entity));
            int remainingSlots = 2 - existingRoots.size();
            if (remainingSlots <= 0) {
                return;
            }
            count = remainingSlots;
            boolean[] occupiedPoints = new boolean[2];
            for (RootsEntity root : existingRoots) {
                int pointIndex = root.getAttachmentPointIndex();
                if (pointIndex < 0 || pointIndex >= 2) continue;
                occupiedPoints[pointIndex] = true;
            }
            for (int i = 0; i < count; ++i) {
                int attachmentPoint = -1;
                for (int j = 0; j < 2; ++j) {
                    if (occupiedPoints[j]) continue;
                    attachmentPoint = j;
                    occupiedPoints[j] = true;
                    break;
                }
                if (attachmentPoint == -1) continue;
                RootsEntity roots2 = new RootsEntity(entity.m_9236_(), entity, attachmentPoint);
                serverLevel.m_7967_((Entity)roots2);
            }
        }
    }

    private static void repairEntityEquipment(LivingEntity entity, int amplifier) {
        OverRooting.repairItem(entity.m_21205_(), amplifier);
        OverRooting.repairItem(entity.m_21206_(), amplifier);
        for (ItemStack stack : entity.m_6168_()) {
            OverRooting.repairItem(stack, amplifier);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                OverRooting.repairItem(stack, amplifier);
            }
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            for (ItemStack stack : mob.m_6167_()) {
                OverRooting.repairItem(stack, amplifier);
            }
            for (ItemStack stack : mob.m_6168_()) {
                OverRooting.repairItem(stack, amplifier);
            }
        }
    }

    private static void repairItem(ItemStack stack, int amplifier) {
        if (stack.m_41783_() != null && !stack.m_41619_() && stack.m_41768_() && stack.m_41782_() && stack.m_41783_().m_128441_("RootedRepair")) {
            int repairAmount = (int)((float)stack.m_41776_() * 0.01f * (float)(amplifier + 1));
            if (repairAmount < 1) {
                repairAmount = 1;
            }
            stack.m_41721_(Math.max(0, stack.m_41773_() - repairAmount));
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        int interval = 100;
        return duration % interval == 0;
    }

    public static void handleEntityDeath(LivingEntity entity) {
        if (entity.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            CompoundTag entityTag = new CompoundTag();
            entity.m_20223_(entityTag);
            CompoundTag persistentData = entity.getPersistentData();
            if (persistentData.m_128441_("HyperplasiaValue")) {
                int hyperplasiaValue = persistentData.m_128451_("HyperplasiaValue");
                entityTag.m_128405_("HyperplasiaValue", hyperplasiaValue);
                String hyperplasiaType = null;
                if (persistentData.m_128441_("HyperplasiaType")) {
                    hyperplasiaType = persistentData.m_128461_("HyperplasiaType");
                    entityTag.m_128359_("HyperplasiaType", hyperplasiaType);
                }
            }
            float maxHealth = entity.m_21233_();
            float newHealth = maxHealth / 3.0f;
            entityTag.m_128350_("Health", newHealth);
            entityTag.m_128473_("DeathTime");
            entityTag.m_128473_("HurtTime");
            entityTag.m_128379_("ResurrectedEntity", true);
            ListTag handDropChances = new ListTag();
            handDropChances.add((Object)FloatTag.m_128566_((float)0.0f));
            handDropChances.add((Object)FloatTag.m_128566_((float)0.0f));
            entityTag.m_128365_("HandDropChances", (Tag)handDropChances);
            ListTag armorDropChances = new ListTag();
            armorDropChances.add((Object)FloatTag.m_128566_((float)0.0f));
            armorDropChances.add((Object)FloatTag.m_128566_((float)0.0f));
            armorDropChances.add((Object)FloatTag.m_128566_((float)0.0f));
            armorDropChances.add((Object)FloatTag.m_128566_((float)0.0f));
            entityTag.m_128365_("ArmorDropChances", (Tag)armorDropChances);
            OverRooting.spawnSwollenTaro(entity.m_9236_(), entity.m_20183_(), entityTag, drops);
        }
    }

    private static void spawnSwollenTaro(Level level, BlockPos pos, @Nullable CompoundTag entityTag, List<ItemStack> drops) {
        if (!level.f_46443_) {
            BlockPos taroPos = OverRooting.findSuitablePosition(level, pos);
            BlockState taroState = ((Block)ModBlock.BLOATED_SONWFALL_TARO_TUBER.get()).m_49966_();
            if (taroState.m_60710_((LevelReader)level, taroPos)) {
                level.m_7731_(taroPos, taroState, 3);
                BlockEntity blockEntity = level.m_7702_(taroPos);
                if (blockEntity instanceof BloatedSnowfallTaroTuberBlockEntity) {
                    BloatedSnowfallTaroTuberBlockEntity blockEntity2 = (BloatedSnowfallTaroTuberBlockEntity)blockEntity;
                    blockEntity2.setEntityData(entityTag);
                    blockEntity2.setStoredDrops(drops);
                }
            }
        }
    }

    public static void handleKill(LivingEntity killer, LivingEntity victim) {
        MobEffectInstance effect;
        if (killer.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get()) && (effect = killer.m_21124_((MobEffect)ModEffects.OVER_ROOTING.get())) != null) {
            int currentAmplifier = effect.m_19564_();
            Level level = killer.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PollenData pollenData = PollenData.get(serverLevel);
                int pollenValue = pollenData.getPollenValueAtWithExtra(killer.m_20183_(), killer);
                if (HyperplasiaSystem.checkAndUnlockSystem(killer, pollenData)) {
                    HyperplasiaSystem.addHyperplasiaValue(killer, pollenData);
                }
                int newAmplifier = currentAmplifier;
                long upgradeThreshold = (long)Math.pow(10.0, currentAmplifier + 2);
                while ((long)pollenValue >= upgradeThreshold) {
                    upgradeThreshold = (long)Math.pow(10.0, ++newAmplifier + 2);
                    if (newAmplifier < 255) continue;
                    newAmplifier = 255;
                    break;
                }
                if (newAmplifier > currentAmplifier) {
                    killer.m_7292_(new MobEffectInstance((MobEffect)ModEffects.OVER_ROOTING.get(), Integer.MAX_VALUE, newAmplifier, true, true, true));
                }
                OverRooting.ensureLifeMultiplierAndFrostAvoidance(killer, newAmplifier, pollenValue);
            }
        }
    }

    private static void ensureLifeMultiplierAndFrostAvoidance(LivingEntity entity, int amplifier, int pollenValue) {
        MobEffectInstance lifeMultiplierEffect = entity.m_21124_((MobEffect)ModEffects.LIFE_MULTIPLIER.get());
        if (pollenValue >= 100 && !((Boolean)ModConfig.DISABLE_LIFE_MULTIPLIER.get()).booleanValue()) {
            if (lifeMultiplierEffect == null) {
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.LIFE_MULTIPLIER.get(), Integer.MAX_VALUE, amplifier, true, true, true));
            } else if (lifeMultiplierEffect.m_19564_() < amplifier) {
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.LIFE_MULTIPLIER.get(), Integer.MAX_VALUE, amplifier, true, true, true));
            }
        }
        MobEffectInstance frostAvoidanceEffect = entity.m_21124_((MobEffect)ModEffects.FROST_AVOIDANCE.get());
        if (pollenValue >= 100 && frostAvoidanceEffect == null) {
            entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_AVOIDANCE.get(), Integer.MAX_VALUE, 0, true, true, true));
        }
    }

    private static BlockPos findSuitablePosition(Level level, BlockPos pos) {
        if (level.m_46859_(pos)) {
            return pos;
        }
        for (BlockPos candidate : BlockPos.m_121925_((BlockPos)pos, (int)2, (int)2, (int)2)) {
            if (!level.m_46859_(candidate)) continue;
            return candidate;
        }
        if (level.m_46859_(pos.m_7494_())) {
            return pos.m_7494_();
        }
        return pos;
    }

    public static float handleFrostDamageBonus(LivingEntity attacker, LivingEntity victim, float originalDamage) {
        if (attacker.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
            return (float)((double)originalDamage * (Double)ModConfig.OVER_ROOTING_DAMAGE_MULTIPLIER.get());
        }
        return originalDamage;
    }

    public static void handleGroupAggro(LivingEntity victim, LivingEntity attacker) {
        if (victim.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
            List nearbyEntities = victim.m_9236_().m_6443_(LivingEntity.class, victim.m_20191_().m_82400_(96.0), e -> e != victim && e.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get()));
            for (LivingEntity entity : nearbyEntities) {
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                mob.m_6710_(attacker);
                if (!(mob instanceof NeutralMob)) continue;
                NeutralMob neutralMob = (NeutralMob)mob;
                neutralMob.m_7870_(600);
                if (attacker instanceof Player) {
                    neutralMob.m_6925_(attacker.m_20148_());
                }
                neutralMob.m_6825_();
            }
        }
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    public void m_6386_(LivingEntity entity, @NotNull AttributeMap attributeMap, int amplifier) {
        entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.OVER_ROOTING.get(), Integer.MAX_VALUE, amplifier, true, true, true));
    }
}

