/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.effect.debuff;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;
import org.cryofloric_arts.hao111111111.Cryofloric_arts;
import org.cryofloric_arts.hao111111111.PlantSpreader;
import org.cryofloric_arts.hao111111111.config.ModConfig;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.world.storage.PollenData;

public class FrostPowder
extends MobEffect {
    private static final Random RANDOM = new Random();

    public FrostPowder() {
        super(MobEffectCategory.NEUTRAL, 7844863);
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    public static void handleEntityDeath(LivingEntity entity) {
        if (entity.m_21023_((MobEffect)ModEffects.FROST_POWDER.get())) {
            Level level = entity.m_9236_();
            PollenData pollenData = PollenData.get((ServerLevel)level);
            pollenData.addPollen((ServerLevel)level, entity.m_146902_(), 1);
            FrostPowder.spawnBloom(entity.m_9236_(), entity.m_20183_());
        }
    }

    public static void handleKill(LivingEntity killer, LivingEntity victim) {
        MobEffectInstance effect;
        if (killer.m_21023_((MobEffect)ModEffects.FROST_POWDER.get()) && (effect = killer.m_21124_((MobEffect)ModEffects.FROST_POWDER.get())) != null) {
            int currentAmplifier = effect.m_19564_();
            int currentDuration = effect.m_19557_();
            Level level = killer.m_9236_();
            PollenData pollenData = PollenData.get((ServerLevel)level);
            pollenData.addPollen((ServerLevel)level, killer.m_146902_(), 1);
            if (RANDOM.nextFloat() < 0.5f) {
                int newAmplifier = Math.min(currentAmplifier + 1, 9);
                int newDuration = currentDuration + 3600;
                if (currentAmplifier >= 9) {
                    FrostPowder.addExtraPollenValue(killer, 1);
                }
                if (!FrostPowder.isEntityInOverRootingBlacklist(killer)) {
                    if (killer.m_21124_((MobEffect)ModEffects.SORE_RUSH.get()) == null) {
                        killer.m_5634_(10.0f + killer.m_21233_() * 0.05f);
                    } else {
                        killer.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SORE_RUSH.get(), Objects.requireNonNull(killer.m_21124_((MobEffect)ModEffects.SORE_RUSH.get())).m_19557_(), Objects.requireNonNull(killer.m_21124_((MobEffect)ModEffects.SORE_RUSH.get())).m_19564_() + 1));
                    }
                    if (newAmplifier > 3) {
                        killer.m_7292_(new MobEffectInstance((MobEffect)ModEffects.OVER_ROOTING.get(), newDuration, 0, true, true, true));
                        killer.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), newDuration, newAmplifier, true, true, true));
                    } else {
                        killer.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), newDuration, newAmplifier));
                    }
                }
            }
            FrostPowder.spawnBloom(killer.m_9236_(), victim.m_20183_());
        }
    }

    private static boolean isEntityInOverRootingBlacklist(LivingEntity entity) {
        List blacklist = (List)ModConfig.FROST_POWDER_OVER_ROOTING_BLACKLIST.get();
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return false;
        }
        String entityNamespace = entityId.m_135827_();
        for (String entry : blacklist) {
            if (entry.startsWith("#")) {
                String tagName = entry.substring(1);
                try {
                    ResourceLocation tagLocation = new ResourceLocation(tagName);
                    TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)tagLocation);
                    if (!entity.m_6095_().m_204039_(tagKey)) continue;
                    return true;
                }
                catch (Exception e) {
                    Cryofloric_arts.LOGGER.warn("\u6807\u7b7e\u683c\u5f0f\u65e0\u6548: {}", (Object)tagName);
                    continue;
                }
            }
            if (!(entry.contains(":") ? entry.equals(entityId.toString()) : entry.equals(entityNamespace))) continue;
            return true;
        }
        return false;
    }

    public static void addExtraPollenValue(LivingEntity entity, int amount) {
        if (entity != null) {
            int currentExtra = entity.getPersistentData().m_128451_("ExtraPollen");
            int newExtra = currentExtra + amount;
            entity.getPersistentData().m_128405_("ExtraPollen", newExtra);
        }
    }

    private static void spawnBloom(Level level, BlockPos pos) {
        BlockPos flowerPos = FrostPowder.findSuitablePosition(level, pos);
        BlockState targetState = PlantSpreader.spawnIcePetalBloom((ServerLevel)level, flowerPos);
        if (targetState.m_60710_((LevelReader)level, flowerPos)) {
            level.m_7731_(flowerPos, targetState, 2);
        }
    }

    private static BlockPos findSuitablePosition(Level level, BlockPos pos) {
        if (level.m_46859_(pos) || level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_)) {
            return pos;
        }
        for (BlockPos candidate : BlockPos.m_121925_((BlockPos)pos, (int)2, (int)2, (int)2)) {
            if (!level.m_46859_(candidate) && !level.m_6425_(candidate).m_192917_((Fluid)Fluids.f_76193_)) continue;
            return candidate;
        }
        if (level.m_46859_(pos.m_7494_()) || level.m_6425_(pos.m_7494_()).m_192917_((Fluid)Fluids.f_76193_)) {
            return pos.m_7494_();
        }
        return pos;
    }
}

