/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.entity.custom;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.jetbrains.annotations.NotNull;

public abstract class SnowfallTaroCreature
extends Animal
implements NeutralMob {
    protected int overRootingLevel;
    protected int frostPowderLevel;
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public boolean m_6914_(LevelReader level) {
        BlockPos pos = this.m_20183_();
        BlockState blockState = level.m_8055_(pos.m_7495_());
        return (blockState.m_60713_((Block)ModBlock.FROSTED_STONE.get()) || blockState.m_60713_((Block)ModBlock.FROSTED_DIRT.get())) && super.m_6914_(level);
    }

    public SnowfallTaroCreature(EntityType<? extends Animal> type, Level level, int overRootingLevel, int frostPowderLevel) {
        super(type, level);
        this.overRootingLevel = overRootingLevel;
        this.frostPowderLevel = frostPowderLevel;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            MobEffectInstance frostPowder;
            MobEffectInstance overRooting = this.m_21124_((MobEffect)ModEffects.OVER_ROOTING.get());
            if (overRooting == null || overRooting.m_19557_() < 100) {
                this.m_7292_(new MobEffectInstance((MobEffect)ModEffects.OVER_ROOTING.get(), 600, this.overRootingLevel, false, false));
            }
            if ((frostPowder = this.m_21124_((MobEffect)ModEffects.FROST_POWDER.get())) == null || frostPowder.m_19557_() < 100) {
                this.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), 600, this.frostPowderLevel, false, false));
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_41720_() == Items.f_42655_) {
            if (player.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get())) {
                return super.m_6071_(player, hand);
            }
            return InteractionResult.FAIL;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6573_(@NotNull Player player) {
        return player != null && player.m_21023_((MobEffect)ModEffects.OVER_ROOTING.get());
    }

    public boolean m_203441_(FluidState fluid) {
        return fluid.m_205070_(FluidTags.f_13131_) || super.m_203441_(fluid);
    }

    public int m_146888_() {
        return 0;
    }

    public void m_146917_(int p_146918_) {
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Entity entity;
        boolean hurt = super.m_6469_(source, amount);
        if (source.equals(this.m_269291_().m_269109_())) {
            return false;
        }
        if (hurt && !this.m_9236_().f_46443_ && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            this.callForReinforcements(attacker);
            this.m_7870_(600);
            this.m_6925_(attacker.m_20148_());
        }
        return hurt;
    }

    protected void callForReinforcements(LivingEntity attacker) {
        AABB area = new AABB(this.m_20183_()).m_82400_(16.0);
        List allies = this.m_9236_().m_45976_(SnowfallTaroCreature.class, area);
        for (SnowfallTaroCreature ally : allies) {
            if (ally == this || ally.m_5448_() != null) continue;
            ally.m_6710_(attacker);
            ally.m_6925_(attacker.m_20148_());
            ally.m_7870_(600);
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, ally.m_20185_(), ally.m_20186_() + (double)ally.m_20206_(), ally.m_20189_(), 5, 0.3, 0.3, 0.3, 0.0);
        }
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int time) {
        this.remainingPersistentAngerTime = time;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID target) {
        this.persistentAngerTarget = target;
    }

    public void m_6825_() {
        this.m_7870_(600);
    }
}

