/*
 * Decompiled with CFR 0.152.
 */
package org.cryofloric_arts.hao111111111.entity.custom;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.cryofloric_arts.hao111111111.blockentity.WinterThornBlockEntity;
import org.cryofloric_arts.hao111111111.blocks.ModBlock;
import org.cryofloric_arts.hao111111111.effect.ModEffects;
import org.cryofloric_arts.hao111111111.entity.custom.SnowfallTaroCreature;
import org.jetbrains.annotations.NotNull;

public class WinterThornMother
extends SnowfallTaroCreature {
    private int growth = 0;
    private int thornSpawnTimer = 0;
    private int healTimer = 0;

    public WinterThornMother(EntityType<? extends Animal> type, Level level) {
        super(type, level, 0, 9);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_8107_() {
        Level level;
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19797_ % 100 == 0) {
                ++this.growth;
                this.updateHealthFromGrowth();
            }
            ++this.healTimer;
            if (this.healTimer >= 200) {
                float maxHealth = this.m_21233_();
                float healAmount = maxHealth * 0.01f;
                this.m_5634_(healAmount);
                this.healTimer = 0;
            }
            ++this.thornSpawnTimer;
            if (this.thornSpawnTimer >= 100) {
                this.trySpawnWinterThorns(serverLevel);
                this.thornSpawnTimer = 0;
            }
        }
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        boolean hurt = super.m_6469_(source, amount);
        if (!this.m_9236_().f_46443_ && hurt) {
            Level level;
            Entity attacker = source.m_7639_();
            if (attacker instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                this.applyThornsDamage(livingAttacker, amount);
            }
            if ((level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.triggerDefensiveThorns(serverLevel);
            }
        }
        return hurt;
    }

    private void applyThornsDamage(LivingEntity attacker, float originalDamage) {
        float thornsDamage = Math.max(1.0f, originalDamage * 0.3f);
        float growthBonus = (float)((double)this.growth / ((double)this.growth + 300.0)) * 0.5f;
        if (attacker.m_6469_(this.m_269291_().m_269374_((Entity)this), thornsDamage *= 1.0f + growthBonus)) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123754_, attacker.m_20185_(), attacker.m_20186_() + (double)(attacker.m_20206_() / 2.0f), attacker.m_20189_(), 5, 0.3, 0.3, 0.3, 0.1);
            }
            attacker.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROSTED.get(), 100, 0));
        }
    }

    private void triggerDefensiveThorns(ServerLevel level) {
        int defensiveThornCount = 2 + this.f_19796_.m_188503_(3);
        for (int i = 0; i < defensiveThornCount; ++i) {
            int range = 2 + this.f_19796_.m_188503_(2);
            BlockPos center = this.m_20183_();
            int x = center.m_123341_() + level.f_46441_.m_188503_(range * 2 + 1) - range;
            int z = center.m_123343_() + level.f_46441_.m_188503_(range * 2 + 1) - range;
            int y = center.m_123342_() + level.f_46441_.m_188503_(range * 2 + 1) - range;
            BlockPos pos = new BlockPos(x, y, z);
            BlockPos placementPos = this.findPlacementPos(level, pos);
            if (placementPos == null || !level.m_46859_(placementPos) || !level.m_8055_(placementPos).m_60795_()) continue;
            level.m_7731_(placementPos, ((Block)ModBlock.WINTER_THORN.get()).m_49966_(), 3);
            BlockEntity blockEntity = level.m_7702_(placementPos);
            if (blockEntity == null || !(blockEntity instanceof WinterThornBlockEntity)) continue;
            WinterThornBlockEntity winterThornBE = (WinterThornBlockEntity)blockEntity;
            winterThornBE.setMotherUUID(this.m_20148_());
        }
        level.m_8767_((ParticleOptions)ParticleTypes.f_175821_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 15, 1.0, 0.5, 1.0, 0.1);
    }

    private void updateHealthFromGrowth() {
        double baseHealth = 10.0;
        double bonusHealth = (double)this.growth / ((double)this.growth + 1000.0) * 500.0;
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(baseHealth + bonusHealth);
        float healthRatio = this.m_21223_() / this.m_21233_();
        this.m_21153_((float)((baseHealth + bonusHealth) * (double)healthRatio));
    }

    private BlockPos findPlacementPos(ServerLevel level, BlockPos startPos) {
        for (int yOffset = -3; yOffset <= 3; ++yOffset) {
            BlockPos checkPos = startPos.m_6630_(yOffset);
            if (!((Block)ModBlock.WINTER_THORN.get()).m_49966_().m_60710_((LevelReader)level, checkPos)) continue;
            return checkPos;
        }
        return null;
    }

    private void trySpawnWinterThorns(ServerLevel level) {
        int range = this.getThornRange();
        BlockPos center = this.m_20183_();
        for (int i = 0; i < 3; ++i) {
            int x = center.m_123341_() + level.f_46441_.m_188503_(range * 2 + 1) - range;
            int z = center.m_123343_() + level.f_46441_.m_188503_(range * 2 + 1) - range;
            int y = center.m_123342_() + level.f_46441_.m_188503_(range * 2 + 1) - range;
            BlockPos pos = new BlockPos(x, y, z);
            BlockPos placementPos = this.findPlacementPos(level, pos);
            if (placementPos == null || !level.m_46859_(placementPos) || !level.m_8055_(placementPos).m_60795_()) continue;
            level.m_7731_(placementPos, ((Block)ModBlock.WINTER_THORN.get()).m_49966_(), 3);
            BlockEntity blockEntity = level.m_7702_(placementPos);
            if (blockEntity == null || !(blockEntity instanceof WinterThornBlockEntity)) continue;
            WinterThornBlockEntity winterThornBE = (WinterThornBlockEntity)blockEntity;
            winterThornBE.setMotherUUID(this.m_20148_());
        }
    }

    private int getThornRange() {
        return this.growth;
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Growth", this.growth);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Growth")) {
            this.growth = compound.m_128451_("Growth");
            this.updateHealthFromGrowth();
        }
        this.m_7292_(new MobEffectInstance((MobEffect)ModEffects.OVER_ROOTING.get(), Integer.MAX_VALUE, 0, false, false));
        this.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FROST_POWDER.get(), Integer.MAX_VALUE, 8, false, false));
    }

    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        return null;
    }

    public int getGrowth() {
        return this.growth;
    }
}

